/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cayenne.project.DataNodeConfigInfo;
import org.apache.cayenne.project.PartialProject;
import org.apache.cayenne.project.ProjectConfigInfo;
import org.apache.cayenne.project.ProjectException;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.ZipUtil;

public class ProjectConfigurator {
    protected ProjectConfigInfo info;

    public ProjectConfigurator(ProjectConfigInfo info) {
        this.info = info;
    }

    public void execute() throws ProjectException {
        block10: {
            File tmpDir = null;
            File tmpDest = null;
            try {
                if (this.info.getDestJar() == null) {
                    this.info.setDestJar(this.info.getSourceJar());
                }
                this.validate();
                tmpDir = this.makeTempDirectory();
                ZipUtil.unzip(this.info.getSourceJar(), tmpDir);
                this.reconfigureProject(tmpDir);
                tmpDest = this.makeTempDestJar();
                ZipUtil.zip(tmpDest, tmpDir, tmpDir.listFiles(), '/');
                if (this.info.getDestJar().exists() && !this.info.getDestJar().delete()) {
                    throw new IOException("Can't delete old jar file: " + this.info.getDestJar());
                }
                if (!tmpDest.renameTo(this.info.getDestJar())) {
                    throw new IOException("Error renaming: " + tmpDest + " to " + this.info.getDestJar());
                }
                if (tmpDir != null) {
                    this.cleanup(tmpDir);
                }
                if (tmpDest == null) break block10;
                tmpDest.delete();
            }
            catch (IOException ex) {
                try {
                    throw new ProjectException("Error performing reconfiguration.", ex);
                }
                catch (Throwable throwable) {
                    if (tmpDir != null) {
                        this.cleanup(tmpDir);
                    }
                    if (tmpDest != null) {
                        tmpDest.delete();
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void reconfigureProject(File projectDir) throws ProjectException {
        File projectFile = new File(projectDir, "cayenne.xml");
        if (this.info.getAltProjectFile() != null && !Util.copy(this.info.getAltProjectFile(), projectFile)) {
            throw new ProjectException("Can't copy project file: " + this.info.getAltProjectFile());
        }
        Iterator it = this.info.getNodes().iterator();
        boolean needFix = it.hasNext();
        while (it.hasNext()) {
            DataNodeConfigInfo nodeInfo = (DataNodeConfigInfo)it.next();
            String name = nodeInfo.getName();
            File targetDriverFile = new File(projectDir, name + ".driver.xml");
            if ((nodeInfo.getDataSource() != null || nodeInfo.getDriverFile() != null) && targetDriverFile.exists()) {
                targetDriverFile.delete();
            }
            if (nodeInfo.getDriverFile() == null || nodeInfo.getDriverFile().equals(targetDriverFile) || Util.copy(nodeInfo.getDriverFile(), targetDriverFile)) continue;
            throw new ProjectException("Can't copy driver file from " + nodeInfo.getDriverFile());
        }
        if (needFix) {
            PartialProject project = new PartialProject(projectFile);
            project.updateNodes(this.info.getNodes());
            project.save();
        }
    }

    protected File makeTempDestJar() throws IOException {
        File destFolder = this.info.getDestJar().getParentFile();
        if (destFolder != null && !destFolder.isDirectory() && !destFolder.mkdirs()) {
            throw new IOException("Can't create directory: " + destFolder.getCanonicalPath());
        }
        String baseName = "tmp_" + this.info.getDestJar().getName();
        for (int i = 0; i < 50; ++i) {
            File tmpFile;
            File file = tmpFile = destFolder != null ? new File(destFolder, baseName + i) : new File(baseName + i);
            if (tmpFile.exists()) continue;
            return tmpFile;
        }
        throw new IOException("Problems creating temporary file.");
    }

    protected void cleanup(File dir) {
        Util.delete(dir.getPath(), true);
    }

    protected File makeTempDirectory() throws IOException {
        File destFolder = this.info.getDestJar().getParentFile();
        if (destFolder != null && !destFolder.isDirectory() && !destFolder.mkdirs()) {
            throw new IOException("Can't create directory: " + destFolder.getCanonicalPath());
        }
        String baseName = this.info.getDestJar().getName();
        if (baseName.endsWith(".jar")) {
            baseName = baseName.substring(0, baseName.length() - 4);
        }
        for (int i = 0; i < 50; ++i) {
            File tmpDir;
            File file = tmpDir = destFolder != null ? new File(destFolder, baseName + i) : new File(baseName + i);
            if (tmpDir.exists()) continue;
            if (!tmpDir.mkdir()) {
                throw new IOException("Can't create directory: " + tmpDir.getCanonicalPath());
            }
            return tmpDir;
        }
        throw new IOException("Problems creating temporary directory.");
    }

    protected void validate() throws IOException, ProjectException {
        if (this.info == null) {
            throw new ProjectException("ProjectConfig info is not set.");
        }
        if (this.info.getSourceJar() == null) {
            throw new ProjectException("Source jar file is not set.");
        }
        if (!this.info.getSourceJar().isFile()) {
            throw new IOException(this.info.getSourceJar() + " is not a file.");
        }
        if (!this.info.getSourceJar().canRead()) {
            throw new IOException("Can't read file: " + this.info.getSourceJar());
        }
    }
}

