/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.AbstractCallback;
import org.apache.cayenne.reflect.CallbackOnEntity;
import org.apache.cayenne.reflect.CallbackOnListener;

class LifecycleCallbackEventHandler {
    private EntityResolver resolver;
    private Map listeners;
    private Collection defaultListeners;

    LifecycleCallbackEventHandler(EntityResolver resolver) {
        this.resolver = resolver;
        this.listeners = new HashMap();
        this.defaultListeners = new ArrayList();
    }

    private boolean excludingDefaultListeners(Class objectClass) {
        ObjEntity entity = this.resolver.lookupObjEntity(objectClass);
        return entity != null && entity.isExcludingDefaultListeners();
    }

    private boolean excludingSuperclassListeners(Class objectClass) {
        ObjEntity entity = this.resolver.lookupObjEntity(objectClass);
        return entity != null && entity.isExcludingSuperclassListeners();
    }

    boolean isEmpty() {
        return this.listeners.isEmpty() && this.defaultListeners.isEmpty();
    }

    void clear() {
        this.listeners.clear();
        this.defaultListeners.clear();
    }

    void addDefaultListener(Object listener, String methodName) {
        CallbackOnListener callback = new CallbackOnListener(listener, methodName);
        this.addDefaultCallback(callback);
    }

    private void addDefaultCallback(AbstractCallback callback) {
        this.defaultListeners.add(callback);
    }

    void addListener(Class entityClass, String methodName) {
        this.addCallback(entityClass, new CallbackOnEntity(entityClass, methodName));
    }

    void addListener(Class entityClass, Object listener, String methodName) {
        CallbackOnListener callback = new CallbackOnListener(listener, methodName, entityClass);
        this.addCallback(entityClass, callback);
    }

    private void addCallback(Class entityClass, AbstractCallback callback) {
        ArrayList<AbstractCallback> entityListeners = (ArrayList<AbstractCallback>)this.listeners.get(entityClass.getName());
        if (entityListeners == null) {
            entityListeners = new ArrayList<AbstractCallback>(3);
            this.listeners.put(entityClass.getName(), entityListeners);
        }
        entityListeners.add(callback);
    }

    void performCallbacks(Object object) {
        if (!this.defaultListeners.isEmpty() && !this.excludingDefaultListeners(object.getClass())) {
            Iterator it = this.defaultListeners.iterator();
            while (it.hasNext()) {
                ((AbstractCallback)it.next()).performCallback(object);
            }
        }
        this.performCallbacks(object, object.getClass());
    }

    void performCallbacks(Collection objects) {
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            this.performCallbacks(object);
        }
    }

    private void performCallbacks(Object object, Class callbackEntityClass) {
        String key;
        Collection entityListeners;
        if (Object.class.equals(callbackEntityClass) || callbackEntityClass == null) {
            return;
        }
        if (!this.excludingSuperclassListeners(callbackEntityClass)) {
            this.performCallbacks(object, callbackEntityClass.getSuperclass());
        }
        if ((entityListeners = (Collection)this.listeners.get(key = callbackEntityClass.getName())) != null) {
            Iterator it = entityListeners.iterator();
            while (it.hasNext()) {
                ((AbstractCallback)it.next()).performCallback(object);
            }
        }
    }
}

