/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.Fault;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.generic.DataObjectBaseProperty;

class DataObjectToManyProperty
extends DataObjectBaseProperty
implements ToManyProperty {
    protected ObjRelationship relationship;
    protected String reverseName;
    protected ClassDescriptor targetDescriptor;

    DataObjectToManyProperty(ObjRelationship relationship, ClassDescriptor targetDescriptor) {
        this.relationship = relationship;
        this.targetDescriptor = targetDescriptor;
        this.reverseName = relationship.getReverseRelationshipName();
    }

    public ArcProperty getComplimentaryReverseArc() {
        return this.reverseName != null ? (ArcProperty)this.targetDescriptor.getProperty(this.reverseName) : null;
    }

    public ClassDescriptor getTargetDescriptor() {
        return this.targetDescriptor;
    }

    public String getName() {
        return this.relationship.getName();
    }

    public ObjRelationship getRelationship() {
        return this.relationship;
    }

    public void addTarget(Object source, Object target, boolean setReverse) throws PropertyException {
        try {
            this.toDataObject(source).addToManyTarget(this.getName(), this.toDataObject(target), setReverse);
        }
        catch (Throwable th) {
            throw new PropertyException("Error setting to-many DataObject property: " + this.getName(), this, source, th);
        }
    }

    public void removeTarget(Object source, Object target, boolean setReverse) throws PropertyException {
        try {
            this.toDataObject(source).removeToManyTarget(this.getName(), this.toDataObject(target), setReverse);
        }
        catch (Throwable th) {
            throw new PropertyException("Error unsetting to-many DataObject property: " + this.getName(), this, source, th);
        }
    }

    public void injectValueHolder(Object object) throws PropertyException {
        if (this.readPropertyDirectly(object) == null) {
            this.writePropertyDirectly(object, null, Fault.getToManyFault().resolveFault((Persistent)object, this.getName()));
        }
    }

    public boolean isFault(Object source) {
        return this.readPropertyDirectly(source) instanceof Fault;
    }

    public boolean visit(PropertyVisitor visitor) {
        return visitor.visitToMany(this);
    }

    public void invalidate(Object object) {
        Object value = this.readPropertyDirectly(object);
        if (!(value instanceof Fault)) {
            if (value instanceof ValueHolder) {
                ((ValueHolder)value).invalidate();
            } else {
                this.writePropertyDirectly(object, null, Fault.getToManyFault());
            }
        }
    }
}

