/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.util.NameConverter;

public class EntityMergeSupport {
    protected DataMap map;
    protected boolean removeMeaningfulFKs;
    static /* synthetic */ Class class$org$apache$cayenne$map$ObjAttribute;
    static /* synthetic */ Class class$org$apache$cayenne$map$ObjRelationship;

    public EntityMergeSupport(DataMap map) {
        this.map = map;
        this.removeMeaningfulFKs = true;
    }

    public boolean synchronizeWithDbEntities(Collection objEntities) {
        boolean changed = false;
        Iterator it = objEntities.iterator();
        while (it.hasNext()) {
            if (!this.synchronizeWithDbEntity((ObjEntity)it.next())) continue;
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchronizeWithDbEntity(ObjEntity entity) {
        if (entity == null || entity.getDbEntity() == null) {
            return false;
        }
        boolean changed = false;
        DataMap dataMap = this.map;
        synchronized (dataMap) {
            String attrName;
            if (this.removeMeaningfulFKs) {
                Iterator rait = this.getMeaningfulFKs(entity).iterator();
                while (rait.hasNext()) {
                    DbAttribute da = (DbAttribute)rait.next();
                    ObjAttribute oa = entity.getAttributeForDbAttribute(da);
                    while (oa != null) {
                        attrName = oa.getName();
                        entity.removeAttribute(attrName);
                        changed = true;
                        oa = entity.getAttributeForDbAttribute(da);
                    }
                }
            }
            List addAttributes = this.getAttributesToAdd(entity);
            Iterator ait = addAttributes.iterator();
            while (ait.hasNext()) {
                DbAttribute da = (DbAttribute)ait.next();
                attrName = NameConverter.underscoredToJava(da.getName(), false);
                attrName = NamedObjectFactory.createName(class$org$apache$cayenne$map$ObjAttribute == null ? EntityMergeSupport.class$("org.apache.cayenne.map.ObjAttribute") : class$org$apache$cayenne$map$ObjAttribute, entity, attrName);
                String type = TypesMapping.getJavaBySqlType(da.getType());
                ObjAttribute oa = new ObjAttribute(attrName, type, entity);
                oa.setDbAttribute(da);
                entity.addAttribute(oa);
                changed = true;
            }
            List addRelationships = this.getRelationshipsToAdd(entity);
            Iterator rit = addRelationships.iterator();
            while (rit.hasNext()) {
                DbRelationship dr = (DbRelationship)rit.next();
                DbEntity dbEntity = (DbEntity)dr.getTargetEntity();
                Iterator targets = this.map.getMappedEntities(dbEntity).iterator();
                if (!targets.hasNext()) continue;
                Entity mappedTarget = (Entity)targets.next();
                String relationshipName = NameConverter.underscoredToJava(dr.getName(), false);
                relationshipName = NamedObjectFactory.createName(class$org$apache$cayenne$map$ObjRelationship == null ? EntityMergeSupport.class$("org.apache.cayenne.map.ObjRelationship") : class$org$apache$cayenne$map$ObjRelationship, entity, relationshipName);
                ObjRelationship or = new ObjRelationship(relationshipName);
                or.addDbRelationship(dr);
                or.setSourceEntity(entity);
                or.setTargetEntity(mappedTarget);
                entity.addRelationship(or);
                changed = true;
            }
        }
        return changed;
    }

    public Collection getMeaningfulFKs(ObjEntity objEntity) {
        ArrayList<DbAttribute> fks = new ArrayList<DbAttribute>(2);
        Iterator it = objEntity.getAttributes().iterator();
        while (it.hasNext()) {
            ObjAttribute property = (ObjAttribute)it.next();
            DbAttribute column = property.getDbAttribute();
            if (column == null || !column.isForeignKey()) continue;
            fks.add(column);
        }
        return fks;
    }

    protected List getAttributesToAdd(ObjEntity objEntity) {
        ArrayList<DbAttribute> missing = new ArrayList<DbAttribute>();
        Iterator it = objEntity.getDbEntity().getAttributes().iterator();
        Collection rels = objEntity.getDbEntity().getRelationships();
        while (it.hasNext()) {
            DbAttribute dba = (DbAttribute)it.next();
            if (objEntity.getAttributeForDbAttribute(dba) != null || dba.getName() == null || dba.isPrimaryKey()) continue;
            boolean isFK = false;
            Iterator rit = rels.iterator();
            block1: while (!isFK && rit.hasNext()) {
                DbRelationship rel = (DbRelationship)rit.next();
                Iterator jit = rel.getJoins().iterator();
                while (jit.hasNext()) {
                    DbJoin join = (DbJoin)jit.next();
                    if (join.getSource() != dba) continue;
                    isFK = true;
                    continue block1;
                }
            }
            if (isFK) continue;
            missing.add(dba);
        }
        return missing;
    }

    protected List getRelationshipsToAdd(ObjEntity objEntity) {
        ArrayList<DbRelationship> missing = new ArrayList<DbRelationship>();
        Iterator it = objEntity.getDbEntity().getRelationships().iterator();
        while (it.hasNext()) {
            DbRelationship dbrel = (DbRelationship)it.next();
            if (dbrel.getName() == null || objEntity.getRelationshipForDbRelationship(dbrel) != null) continue;
            missing.add(dbrel);
        }
        return missing;
    }

    public DataMap getMap() {
        return this.map;
    }

    public void setMap(DataMap map) {
        this.map = map;
    }

    public boolean isRemoveMeaningfulFKs() {
        return this.removeMeaningfulFKs;
    }

    public void setRemoveMeaningfulFKs(boolean removeMeaningfulFKs) {
        this.removeMeaningfulFKs = removeMeaningfulFKs;
    }
}

