/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;

public final class DataObjectUtils {
    public static int intPKForObject(Persistent dataObject) {
        Object value = DataObjectUtils.pkForObject(dataObject);
        if (!(value instanceof Number)) {
            throw new CayenneRuntimeException("PK is not a number: " + dataObject.getObjectId());
        }
        return ((Number)value).intValue();
    }

    public static Object pkForObject(Persistent dataObject) {
        Map pk = DataObjectUtils.extractObjectId(dataObject);
        if (pk.size() != 1) {
            throw new CayenneRuntimeException("Expected single column PK, got " + pk.size() + " columns, ID: " + pk);
        }
        Map.Entry pkEntry = pk.entrySet().iterator().next();
        return pkEntry.getValue();
    }

    public static Map compoundPKForObject(Persistent dataObject) {
        return Collections.unmodifiableMap(DataObjectUtils.extractObjectId(dataObject));
    }

    static Map extractObjectId(Persistent dataObject) {
        DbEntity entity;
        ObjEntity objEntity;
        if (dataObject == null) {
            throw new IllegalArgumentException("Null DataObject");
        }
        ObjectId id = dataObject.getObjectId();
        if (!id.isTemporary()) {
            return id.getIdSnapshot();
        }
        if (id.isReplacementIdAttached() && (objEntity = dataObject.getObjectContext().getEntityResolver().lookupObjEntity(dataObject)) != null && (entity = objEntity.getDbEntity()) != null && entity.isFullReplacementIdAttached(id)) {
            return id.getReplacementIdMap();
        }
        throw new CayenneRuntimeException("Can't get primary key from temporary id.");
    }

    public static Object objectForPK(ObjectContext context, Class dataObjectClass, int pk) {
        return DataObjectUtils.objectForPK(context, DataObjectUtils.buildId(context, dataObjectClass, (Object)new Integer(pk)));
    }

    public static Object objectForPK(ObjectContext context, Class dataObjectClass, Object pk) {
        return DataObjectUtils.objectForPK(context, DataObjectUtils.buildId(context, dataObjectClass, pk));
    }

    public static Object objectForPK(ObjectContext context, Class dataObjectClass, Map pk) {
        ObjEntity entity = context.getEntityResolver().lookupObjEntity(dataObjectClass);
        if (entity == null) {
            throw new CayenneRuntimeException("Non-existent ObjEntity for class: " + dataObjectClass);
        }
        return DataObjectUtils.objectForPK(context, new ObjectId(entity.getName(), pk));
    }

    public static Object objectForPK(ObjectContext context, String objEntityName, int pk) {
        return DataObjectUtils.objectForPK(context, DataObjectUtils.buildId(context, objEntityName, (Object)new Integer(pk)));
    }

    public static Object objectForPK(ObjectContext context, String objEntityName, Object pk) {
        return DataObjectUtils.objectForPK(context, DataObjectUtils.buildId(context, objEntityName, pk));
    }

    public static Object objectForPK(ObjectContext context, String objEntityName, Map pk) {
        if (objEntityName == null) {
            throw new IllegalArgumentException("Null ObjEntity name.");
        }
        return DataObjectUtils.objectForPK(context, new ObjectId(objEntityName, pk));
    }

    public static Object objectForPK(ObjectContext context, ObjectId id) {
        return DataObjectUtils.objectForQuery(context, new ObjectIdQuery(id, false, 1));
    }

    public static Object objectForQuery(ObjectContext context, Query query) {
        List objects = context.performQuery(query);
        if (objects.size() == 0) {
            return null;
        }
        if (objects.size() > 1) {
            throw new CayenneRuntimeException("Expected zero or one object, instead query matched: " + objects.size());
        }
        return objects.get(0);
    }

    static ObjectId buildId(ObjectContext context, String objEntityName, Object pk) {
        if (pk == null) {
            throw new IllegalArgumentException("Null PK");
        }
        if (objEntityName == null) {
            throw new IllegalArgumentException("Null ObjEntity name.");
        }
        ObjEntity entity = context.getEntityResolver().getObjEntity(objEntityName);
        if (entity == null) {
            throw new CayenneRuntimeException("Non-existent ObjEntity: " + objEntityName);
        }
        DbEntity dbEntity = entity.getDbEntity();
        if (dbEntity == null) {
            throw new CayenneRuntimeException("No DbEntity for ObjEntity: " + entity.getName());
        }
        List pkAttributes = dbEntity.getPrimaryKey();
        if (pkAttributes.size() != 1) {
            throw new CayenneRuntimeException("PK contains " + pkAttributes.size() + " columns, expected 1.");
        }
        DbAttribute attr = (DbAttribute)pkAttributes.get(0);
        return new ObjectId(objEntityName, attr.getName(), pk);
    }

    static ObjectId buildId(ObjectContext context, Class dataObjectClass, Object pk) {
        if (pk == null) {
            throw new IllegalArgumentException("Null PK");
        }
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("Null DataObject class.");
        }
        ObjEntity entity = context.getEntityResolver().lookupObjEntity(dataObjectClass);
        if (entity == null) {
            throw new CayenneRuntimeException("Unmapped DataObject Class: " + dataObjectClass.getName());
        }
        DbEntity dbEntity = entity.getDbEntity();
        if (dbEntity == null) {
            throw new CayenneRuntimeException("No DbEntity for ObjEntity: " + entity.getName());
        }
        List pkAttributes = dbEntity.getPrimaryKey();
        if (pkAttributes.size() != 1) {
            throw new CayenneRuntimeException("PK contains " + pkAttributes.size() + " columns, expected 1.");
        }
        DbAttribute attr = (DbAttribute)pkAttributes.get(0);
        return new ObjectId(entity.getName(), attr.getName(), pk);
    }

    private DataObjectUtils() {
    }
}

