/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.util.IDUtil;
import org.apache.cayenne.util.Util;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ObjectId
implements Serializable {
    protected String entityName;
    protected Map objectIdKeys;
    private String singleKey;
    private Object singleValue;
    protected byte[] key;
    protected Map replacementIdMap;
    transient int hashCode;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ObjectId() {
    }

    public ObjectId(String entityName) {
        this.entityName = entityName;
        this.key = IDUtil.pseudoUniqueByteSequence8();
    }

    public ObjectId(String entityName, byte[] key) {
        this.entityName = entityName;
        this.key = key;
    }

    public ObjectId(String entityName, String key, int value) {
        this(entityName, key, new Integer(value));
    }

    public ObjectId(String entityName, String key, Object value) {
        this.entityName = entityName;
        this.singleKey = key;
        this.singleValue = value;
    }

    public ObjectId(String entityName, Map idMap) {
        this.entityName = entityName;
        if (idMap != null && idMap.size() != 0) {
            if (idMap.size() == 1) {
                Map.Entry e = idMap.entrySet().iterator().next();
                this.singleKey = String.valueOf(e.getKey());
                this.singleValue = e.getValue();
            } else {
                this.objectIdKeys = new HashMap(idMap);
            }
        }
    }

    public boolean isTemporary() {
        return this.key != null;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public byte[] getKey() {
        return this.key;
    }

    public Map getIdSnapshot() {
        if (this.isTemporary()) {
            return this.replacementIdMap == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.replacementIdMap);
        }
        if (this.singleKey != null) {
            return Collections.singletonMap(this.singleKey, this.singleValue);
        }
        return this.objectIdKeys != null ? Collections.unmodifiableMap(this.objectIdKeys) : Collections.EMPTY_MAP;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectId)) {
            return false;
        }
        ObjectId id = (ObjectId)object;
        if (!Util.nullSafeEquals(this.entityName, id.entityName)) {
            return false;
        }
        if (this.isTemporary()) {
            return new EqualsBuilder().append(this.key, id.key).isEquals();
        }
        if (this.singleKey != null) {
            return Util.nullSafeEquals(this.singleKey, id.singleKey) && this.valueEquals(this.singleValue, id.singleValue);
        }
        if (id.objectIdKeys == null) {
            return this.objectIdKeys == null;
        }
        if (id.objectIdKeys.size() != this.objectIdKeys.size()) {
            return false;
        }
        Iterator entries = this.objectIdKeys.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (!(entryValue == null ? id.objectIdKeys.get(entryKey) != null || !id.objectIdKeys.containsKey(entryKey) : !this.valueEquals(entryValue, id.objectIdKeys.get(entryKey)))) continue;
            return false;
        }
        return true;
    }

    private final boolean valueEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o1 instanceof Number) {
            return o2 instanceof Number && ((Number)o1).longValue() == ((Number)o2).longValue();
        }
        if (o1.getClass().isArray()) {
            return new EqualsBuilder().append(o1, o2).isEquals();
        }
        return Util.nullSafeEquals(o1, o2);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder(3, 5);
            builder.append(this.entityName.hashCode());
            if (this.key != null) {
                builder.append(this.key);
            } else if (this.singleKey != null) {
                builder.append(this.singleKey.hashCode());
                if (this.singleValue instanceof Number) {
                    builder.append(((Number)this.singleValue).longValue());
                } else {
                    builder.append(this.singleValue);
                }
            } else if (this.objectIdKeys != null) {
                int len = this.objectIdKeys.size();
                Object[] keys = this.objectIdKeys.keySet().toArray();
                Arrays.sort(keys);
                for (int i = 0; i < len; ++i) {
                    builder.append(i);
                    Object value = this.objectIdKeys.get(keys[i]);
                    if (value instanceof Number) {
                        builder.append(((Number)value).longValue());
                        continue;
                    }
                    builder.append(value);
                }
            }
            this.hashCode = builder.toHashCode();
            if (!$assertionsDisabled && this.hashCode == 0) {
                throw new AssertionError((Object)"Generated zero hashCode");
            }
        }
        return this.hashCode;
    }

    public Map getReplacementIdMap() {
        if (this.replacementIdMap == null) {
            this.replacementIdMap = new HashMap();
        }
        return this.replacementIdMap;
    }

    public ObjectId createReplacementId() {
        HashMap newIdMap = new HashMap(this.getIdSnapshot());
        if (this.replacementIdMap != null) {
            newIdMap.putAll(this.replacementIdMap);
        }
        return new ObjectId(this.getEntityName(), newIdMap);
    }

    public boolean isReplacementIdAttached() {
        return this.replacementIdMap != null && !this.replacementIdMap.isEmpty();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<ObjectId:").append(this.entityName);
        if (this.isTemporary()) {
            buffer.append(", TEMP:");
            for (int i = 0; i < this.key.length; ++i) {
                IDUtil.appendFormattedByte(buffer, this.key[i]);
            }
        } else if (this.singleKey != null) {
            buffer.append(", ").append(String.valueOf(this.singleKey)).append("=").append(this.singleValue);
        } else if (this.objectIdKeys != null) {
            ArrayList keys = new ArrayList(this.objectIdKeys.keySet());
            Collections.sort(keys);
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                Object key = it.next();
                buffer.append(", ");
                buffer.append(String.valueOf(key)).append("=").append(this.objectIdKeys.get(key));
            }
        }
        buffer.append(">");
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !ObjectId.class.desiredAssertionStatus();
    }
}

