/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.hsqldb.HSQLDBAdapter;

class DbGeneratorPostprocessor {
    private static final Map postprocessors = new HashMap();

    DbGeneratorPostprocessor() {
    }

    void execute(Connection connection) throws SQLException {
        Postprocessor postprocessor;
        DbAdapter adapter = AutoAdapter.getDefaultFactory().createAdapter(connection.getMetaData());
        if (adapter != null && (postprocessor = (Postprocessor)postprocessors.get(adapter.getClass().getName())) != null) {
            postprocessor.execute(connection);
        }
    }

    static {
        postprocessors.put(HSQLDBAdapter.class.getName(), new HSQLDBPostprocessor());
    }

    static class HSQLDBPostprocessor
    extends Postprocessor {
        HSQLDBPostprocessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute(Connection c) throws SQLException {
            PreparedStatement st = c.prepareStatement("CHECKPOINT");
            try {
                st.execute();
            }
            finally {
                st.close();
            }
        }
    }

    static abstract class Postprocessor {
        Postprocessor() {
        }

        abstract void execute(Connection var1) throws SQLException;
    }
}

