/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.QueryResult;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.SelectQuery;

public class OptimisticLockException
extends CayenneRuntimeException {
    protected String querySQL;
    protected DbEntity rootEntity;
    protected Map qualifierSnapshot;

    public OptimisticLockException(DbEntity rootEntity, String querySQL, Map qualifierSnapshot) {
        super("Optimistic Lock Failure");
        this.rootEntity = rootEntity;
        this.querySQL = querySQL;
        this.qualifierSnapshot = qualifierSnapshot != null ? qualifierSnapshot : Collections.EMPTY_MAP;
    }

    public Map getQualifierSnapshot() {
        return this.qualifierSnapshot;
    }

    public String getQuerySQL() {
        return this.querySQL;
    }

    public Map getFreshSnapshot(QueryEngine engine) {
        Expression qualifier = null;
        Iterator it = this.rootEntity.getPrimaryKey().iterator();
        while (it.hasNext()) {
            DbAttribute attribute = (DbAttribute)it.next();
            Expression attributeQualifier = ExpressionFactory.matchDbExp(attribute.getName(), this.qualifierSnapshot.get(attribute.getName()));
            qualifier = qualifier != null ? qualifier.andExp(attributeQualifier) : attributeQualifier;
        }
        SelectQuery query = new SelectQuery(this.rootEntity, qualifier);
        query.setFetchingDataRows(true);
        QueryResult observer = new QueryResult();
        engine.performQueries(Collections.singletonList(query), observer);
        List results = observer.getFirstRows(query);
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new CayenneRuntimeException("More than one row for ObjectId.");
        }
        return (Map)results.get(0);
    }

    public String getMessage() {
        StringBuffer buffer = new StringBuffer(super.getMessage());
        if (this.querySQL != null) {
            buffer.append(", SQL: [").append(this.querySQL.trim()).append("]");
        }
        if (!this.qualifierSnapshot.isEmpty()) {
            buffer.append(", WHERE clause bindings: [");
            Iterator it = this.qualifierSnapshot.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                buffer.append(entry.getKey()).append("=");
                QueryLogger.sqlLiteralForObject(buffer, entry.getValue());
                if (!it.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append("]");
        }
        return buffer.toString();
    }
}

