/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import org.apache.cayenne.access.jdbc.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.jdbc.EJBQLPathTranslator;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;

class EJBQLSelectColumnsTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private int expressionsCount;

    EJBQLSelectColumnsTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    public boolean visitSelectExpression(EJBQLExpression expression) {
        if (this.expressionsCount++ > 0) {
            this.context.append(",");
        }
        return true;
    }

    public boolean visitAggregate(EJBQLExpression expression) {
        expression.visit(this.context.getTranslatorFactory().getAggregateColumnTranslator(this.context));
        return false;
    }

    public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
        EJBQLPathTranslator pathTranslator = new EJBQLPathTranslator(this.context){

            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                throw new EJBQLException("Can't use multi-column paths in column clause");
            }

            protected void processTerminatingAttribute(ObjAttribute attribute) {
                DbEntity table = this.currentEntity.getDbEntity();
                String alias = this.lastAlias != null ? this.lastAlias : EJBQLSelectColumnsTranslator.this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
                DbAttribute dbAttribute = attribute.getDbAttribute();
                if (EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns()) {
                    EJBQLSelectColumnsTranslator.this.context.append(" #result('");
                } else {
                    EJBQLSelectColumnsTranslator.this.context.append(' ');
                }
                EJBQLSelectColumnsTranslator.this.context.append(alias).append('.').append(dbAttribute.getName());
                if (EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns()) {
                    String columnAlias = EJBQLSelectColumnsTranslator.this.context.nextColumnAlias();
                    EJBQLSelectColumnsTranslator.this.context.append("' '").append(attribute.getType()).append("' '").append(columnAlias).append("' '").append(columnAlias).append("' " + dbAttribute.getType()).append(")");
                }
            }
        };
        expression.visit(pathTranslator);
        return false;
    }

    public boolean visitIdentifier(EJBQLExpression expression) {
        expression.visit(this.context.getTranslatorFactory().getIdentifierColumnsTranslator(this.context));
        return false;
    }
}

