/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.File;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.conf.DefaultConfiguration;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileConfiguration
extends DefaultConfiguration {
    private static final Log logger = LogFactory.getLog((Class)FileConfiguration.class);
    protected File projectFile;

    public FileConfiguration() {
        this("cayenne.xml");
    }

    public FileConfiguration(String domainConfigurationName) {
        super(domainConfigurationName);
        this.projectFile = new File(domainConfigurationName);
        ResourceLocator locator = this.getResourceLocator();
        locator.setSkipAbsolutePath(false);
        locator.setSkipClasspath(true);
        locator.setSkipCurrentDirectory(false);
        locator.setSkipHomeDirectory(true);
        File projectDirectory = this.getProjectDirectory();
        if (projectDirectory != null) {
            locator.addFilesystemPath(projectDirectory.getPath());
        }
    }

    public FileConfiguration(File domainConfigurationFile) {
        logger.debug((Object)("using domain file: " + domainConfigurationFile));
        this.setProjectFile(domainConfigurationFile);
        ResourceLocator locator = this.getResourceLocator();
        locator.setSkipAbsolutePath(false);
        locator.setSkipClasspath(true);
        locator.setSkipCurrentDirectory(false);
        locator.setSkipHomeDirectory(true);
        File projectDirectory = this.getProjectDirectory();
        if (projectDirectory != null) {
            locator.addFilesystemPath(projectDirectory);
        }
    }

    public void addFilesystemPath(String path) {
        this.getResourceLocator().addFilesystemPath(path);
    }

    public void addFilesystemPath(File path) {
        this.getResourceLocator().addFilesystemPath(path);
    }

    public boolean canInitialize() {
        return this.getProjectFile() != null;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    protected void setProjectFile(File projectFile) {
        if (projectFile != null) {
            if (!projectFile.isFile()) {
                throw new ConfigurationException("Project file: " + projectFile + " is a directory or not readable.");
            }
        } else {
            throw new ConfigurationException("Cannot use null as project file.");
        }
        this.projectFile = projectFile;
        this.setDomainConfigurationName(projectFile.getName());
    }

    public File getProjectDirectory() {
        File pfile = this.getProjectFile();
        if (pfile != null) {
            return pfile.getParentFile();
        }
        return null;
    }
}

