/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.DbAdapterFactory;

class DbAdapterFactoryChain
implements DbAdapterFactory {
    List factories = new ArrayList();

    DbAdapterFactoryChain(Collection factories) {
        this.factories.addAll(factories);
    }

    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            DbAdapterFactory factory = (DbAdapterFactory)this.factories.get(i);
            DbAdapter adapter = factory.createAdapter(md);
            if (adapter == null) continue;
            return adapter;
        }
        return null;
    }

    void clearFactories() {
        this.factories.clear();
    }

    void addFactory(DbAdapterFactory factory) {
        this.factories.add(factory);
    }
}

