/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.db2;

import java.sql.PreparedStatement;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.BooleanType;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.db2.DB2PkGenerator;
import org.apache.cayenne.dba.db2.DB2QualifierTranslator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DerivedDbEntity;

public class DB2Adapter
extends JdbcAdapter {
    protected PkGenerator createPkGenerator() {
        return new DB2PkGenerator();
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, true));
        map.registerType(new DB2BooleanType());
        map.registerType(new ByteArrayType(false, false));
    }

    public String createTable(DbEntity ent) {
        if (ent instanceof DerivedDbEntity) {
            throw new CayenneRuntimeException("Can't create table for derived DbEntity '" + ent.getName() + "'.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(ent.getFullyQualifiedName()).append(" (");
        Iterator it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = (DbAttribute)it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.");
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType());
            }
            String type = types[0];
            buf.append(at.getName()).append(' ').append(type);
            if (TypesMapping.supportsLength(at.getType())) {
                int scale;
                int len = at.getMaxLength();
                int n = scale = TypesMapping.isDecimal(at.getType()) ? at.getScale() : -1;
                if (scale > len) {
                    scale = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (scale >= 0) {
                        buf.append(", ").append(scale);
                    }
                    buf.append(')');
                }
            }
            if (!at.isMandatory()) continue;
            buf.append(" NOT NULL");
        }
        Iterator pkit = ent.getPrimaryKey().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                buf.append(at.getName());
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new DB2QualifierTranslator(queryAssembler, "RTRIM");
    }

    final class DB2BooleanType
    extends BooleanType {
        DB2BooleanType() {
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (val != null) {
                st.setInt(pos, (Boolean)val != false ? 1 : 0);
            } else {
                st.setNull(pos, type);
            }
        }
    }
}

