/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.EJBQLTranslatorFactory;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.mysql.MySQLActionBuilder;
import org.apache.cayenne.dba.mysql.MySQLEJBQLTranslatorFactory;
import org.apache.cayenne.dba.mysql.MySQLPkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

public class MySQLAdapter
extends JdbcAdapter {
    public MySQLAdapter() {
        this.setSupportsFkConstraints(false);
        this.setSupportsUniqueConstraints(true);
        this.setSupportsGeneratedKeys(true);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new MySQLActionBuilder(this, node.getEntityResolver()));
    }

    public String dropTable(DbEntity entity) {
        return "DROP TABLE IF EXISTS " + entity.getFullyQualifiedName() + " CASCADE";
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(false, false));
        map.registerType(new ByteArrayType(false, false));
    }

    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        if (typeName != null) {
            typeName = typeName.toLowerCase();
        }
        if (type == 1111) {
            if ("longblob".equals(typeName)) {
                type = 2004;
            } else if ("mediumblob".equals(typeName)) {
                type = 2004;
            } else if ("blob".equals(typeName)) {
                type = 2004;
            } else if ("tinyblob".equals(typeName)) {
                type = -3;
            } else if ("longtext".equals(typeName)) {
                type = 2005;
            } else if ("mediumtext".equals(typeName)) {
                type = 2005;
            } else if ("text".equals(typeName)) {
                type = 2005;
            } else if ("tinytext".equals(typeName)) {
                type = 12;
            }
        } else if (typeName != null && typeName.endsWith(" unsigned") && (typeName.equals("int unsigned") || typeName.equals("integer unsigned") || typeName.equals("mediumint unsigned"))) {
            type = -5;
        }
        return super.buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    public String tableTypeForView() {
        return null;
    }

    protected PkGenerator createPkGenerator() {
        return new MySQLPkGenerator();
    }

    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        return new MySQLEJBQLTranslatorFactory();
    }

    public String createTable(DbEntity entity) {
        String ddlSQL = super.createTable(entity);
        ddlSQL = ddlSQL + " ENGINE=InnoDB";
        return ddlSQL;
    }

    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        ArrayList pkList = new ArrayList(entity.getPrimaryKey());
        Collections.sort(pkList, new PKComparator());
        Iterator pkit = pkList.iterator();
        if (pkit.hasNext()) {
            sqlBuffer.append(", PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                sqlBuffer.append(at.getName());
            }
            sqlBuffer.append(')');
        }
        if (this.supportsFkConstraints()) {
            Iterator relationships = entity.getRelationships().iterator();
            while (relationships.hasNext()) {
                DbRelationship relationship = (DbRelationship)relationships.next();
                if (relationship.getJoins().size() <= 0 || !relationship.isToPK() || relationship.isToDependentPK()) continue;
                sqlBuffer.append(", KEY (");
                Iterator columns = relationship.getSourceAttributes().iterator();
                DbAttribute column = (DbAttribute)columns.next();
                sqlBuffer.append(column.getName());
                while (columns.hasNext()) {
                    column = (DbAttribute)columns.next();
                    sqlBuffer.append(", ").append(column.getName());
                }
                sqlBuffer.append(")");
            }
        }
    }

    protected void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        super.createTableAppendColumn(sqlBuffer, column);
        if (column.isGenerated()) {
            sqlBuffer.append(" AUTO_INCREMENT");
        }
    }

    final class PKComparator
    implements Comparator {
        PKComparator() {
        }

        public int compare(Object o1, Object o2) {
            DbAttribute a1 = (DbAttribute)o1;
            DbAttribute a2 = (DbAttribute)o2;
            if (a1.isGenerated() != a2.isGenerated()) {
                return a1.isGenerated() ? -1 : 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }
}

