/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.enhancer;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class EnhancementHelper {
    private static String fieldPrefix = "$cay_";
    private ClassVisitor classVisitor;
    private Type currentClass;

    public static boolean isGeneratedField(String name) {
        return name != null && name.startsWith(fieldPrefix);
    }

    public EnhancementHelper(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    public Type getCurrentClass() {
        return this.currentClass;
    }

    public String getPropertyField(String propertyName) {
        return fieldPrefix + propertyName;
    }

    public void reset(String className) {
        this.currentClass = Type.getType((String)("L" + className + ";"));
    }

    public String[] addInterface(String[] interfaces, Class newInterface) {
        String name = Type.getInternalName((Class)newInterface);
        if (interfaces == null || interfaces.length == 0) {
            return new String[]{name};
        }
        String[] expandedInterfaces = new String[interfaces.length + 1];
        expandedInterfaces[0] = name;
        System.arraycopy(interfaces, 0, expandedInterfaces, 1, interfaces.length);
        return expandedInterfaces;
    }

    public void createField(Class fieldType, String name) {
        this.createField(fieldType, name, false);
    }

    public void createField(Class fieldType, String name, boolean isTransient) {
        Type asmType = Type.getType((Class)fieldType);
        int access = 4;
        if (isTransient) {
            access += 128;
        }
        this.createField(name, asmType, access);
    }

    public void createProperty(Class propertyType, String name) {
        this.createProperty(propertyType, name, false);
    }

    public void createProperty(Class propertyType, String name, boolean isTransient) {
        Type asmType = Type.getType((Class)propertyType);
        int access = 4;
        if (isTransient) {
            access += 128;
        }
        this.createField(name, asmType, access);
        this.createGetter(name, asmType);
        this.createSetter(name, asmType);
    }

    private void createSetter(String propertyName, Type asmType) {
        String methodName = "set" + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.length() > 1) {
            methodName = methodName + propertyName.substring(1);
        }
        MethodVisitor mv = this.classVisitor.visitMethod(1, methodName, "(" + asmType.getDescriptor() + ")V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        if ("I".equals(asmType.getDescriptor())) {
            mv.visitVarInsn(21, 1);
        } else {
            mv.visitVarInsn(25, 1);
        }
        mv.visitFieldInsn(181, this.currentClass.getInternalName(), this.getPropertyField(propertyName), asmType.getDescriptor());
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", this.currentClass.getDescriptor(), null, l0, l1, 0);
        mv.visitLocalVariable(propertyName, asmType.getDescriptor(), null, l0, l1, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void createGetter(String propertyName, Type asmType) {
        String prefix = "boolean".equals(asmType.getClassName()) ? "is" : "get";
        String methodName = prefix + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.length() > 1) {
            methodName = methodName + propertyName.substring(1);
        }
        MethodVisitor mv = this.classVisitor.visitMethod(1, methodName, "()" + asmType.getDescriptor(), null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.currentClass.getInternalName(), this.getPropertyField(propertyName), asmType.getDescriptor());
        if ("I".equals(asmType.getDescriptor())) {
            mv.visitInsn(172);
        } else {
            mv.visitInsn(176);
        }
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", this.currentClass.getDescriptor(), null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void createField(String propertyName, Type asmType, int access) {
        FieldVisitor fv = this.classVisitor.visitField(access, this.getPropertyField(propertyName), asmType.getDescriptor(), null, null);
        fv.visitEnd();
    }
}

