/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.Iterator;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.project.validator.MappingNamesHelper;
import org.apache.cayenne.util.NameConverter;

public class ClassGenerationInfo {
    protected ObjEntity entity;
    protected String packageName;
    protected String className;
    protected String superPrefix;
    protected String prop;
    protected String superPackageName;
    protected String superClassName;

    public String getPackageName() {
        return this.packageName;
    }

    protected void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getSuperPackageName() {
        return this.superPackageName;
    }

    protected void setSuperPackageName(String superPackageName) {
        this.superPackageName = superPackageName;
    }

    public String getClassName() {
        return this.className;
    }

    protected void setClassName(String className) {
        this.className = className;
    }

    protected void setSuperPrefix(String superPrefix) {
        this.superPrefix = superPrefix;
    }

    public String formatJavaType(String type) {
        if (type != null) {
            if (type.startsWith("java.lang.") && type.indexOf(46, 10) < 0) {
                return type.substring("java.lang.".length());
            }
            if (this.packageName != null && type.startsWith(this.packageName + '.') && type.indexOf(this.packageName.length() + 1, 46) < 0) {
                return type.substring(this.packageName.length() + 1);
            }
        }
        return type;
    }

    public String formatVariableName(String variableName) {
        if (MappingNamesHelper.getInstance().isReservedJavaKeyword(variableName)) {
            return "_" + variableName;
        }
        return variableName;
    }

    public String getSuperPrefix() {
        return this.superPrefix;
    }

    public void setProp(String prop) {
        this.prop = prop;
    }

    public String getProp() {
        return this.prop;
    }

    public String capitalized(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char c = Character.toUpperCase(name.charAt(0));
        return name.length() == 1 ? Character.toString(c) : c + name.substring(1);
    }

    public String capitalizedAsConstant(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return NameConverter.javaToUnderscored(name);
    }

    public String getCappedProp() {
        return this.capitalized(this.prop);
    }

    public String getPropAsConstantName() {
        return this.capitalizedAsConstant(this.prop);
    }

    public boolean isContainingDeclaredListProperties() {
        if (this.entity == null) {
            return false;
        }
        Iterator it = this.entity.getDeclaredRelationships().iterator();
        while (it.hasNext()) {
            Relationship r = (Relationship)it.next();
            if (!r.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean isContainingListProperties() {
        if (this.entity == null) {
            return false;
        }
        Iterator it = this.entity.getRelationships().iterator();
        while (it.hasNext()) {
            Relationship r = (Relationship)it.next();
            if (!r.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean isUsingPackage() {
        return this.packageName != null;
    }

    public boolean isUsingSuperPackage() {
        return this.superPackageName != null;
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    protected void setObjEntity(ObjEntity entity) {
        this.entity = entity;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    protected void setSuperClassName(String value) {
        this.superClassName = value;
    }
}

