/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import org.apache.cayenne.project.validator.MappingNamesHelper;
import org.apache.cayenne.util.NameConverter;

public class StringUtils {
    private static StringUtils sharedInstance = null;

    public static StringUtils getInstance() {
        if (null == sharedInstance) {
            sharedInstance = new StringUtils();
        }
        return sharedInstance;
    }

    public String formatVariableName(String variableName) {
        if (MappingNamesHelper.getInstance().isReservedJavaKeyword(variableName)) {
            return "_" + variableName;
        }
        return variableName;
    }

    public String stripPackageName(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        int lastDot = aString.lastIndexOf(46);
        if (-1 == lastDot || aString.length() - 1 == lastDot) {
            return aString;
        }
        return aString.substring(lastDot + 1);
    }

    public String stripClass(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        int lastDot = aString.lastIndexOf(46);
        if (-1 == lastDot) {
            return "";
        }
        return aString.substring(0, lastDot);
    }

    public String capitalized(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char c = Character.toUpperCase(name.charAt(0));
        return name.length() == 1 ? Character.toString(c) : c + name.substring(1);
    }

    public static String uncapitalized(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        char c = Character.toLowerCase(aString.charAt(0));
        return aString.length() == 1 ? Character.toString(c) : c + aString.substring(1);
    }

    public String capitalizedAsConstant(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return NameConverter.javaToUnderscored(name);
    }
}

