/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import javax.persistence.EntityTransaction;
import javax.persistence.TransactionRequiredException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.jpa.JtaEntityManagerFactory;
import org.apache.cayenne.jpa.ResourceLocalEntityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaEntityManager
extends ResourceLocalEntityManager {
    protected Object currentTxKey;

    public JtaEntityManager(ObjectContext context, JtaEntityManagerFactory factory) {
        super(context, factory);
    }

    private JtaEntityManagerFactory getJtaFactory() {
        return (JtaEntityManagerFactory)this.getFactory();
    }

    @Override
    public EntityTransaction getTransaction() {
        throw new IllegalStateException("'getTransaction' is called on a JTA EntityManager");
    }

    @Override
    public void joinTransaction() {
        if (this.currentTxKey == null) {
            TransactionSynchronizationRegistry registry = this.getJtaFactory().getTransactionRegistry();
            registry.registerInterposedSynchronization((Synchronization)new TransactionBinding());
            this.currentTxKey = registry.getTransactionKey();
        }
    }

    @Override
    public void persist(Object entity) {
        this.checkTransaction();
        super.persist(entity);
    }

    @Override
    public <T> T merge(T entity) {
        this.checkTransaction();
        return super.merge(entity);
    }

    @Override
    public void remove(Object entity) {
        this.checkTransaction();
        super.remove(entity);
    }

    @Override
    public void refresh(Object entity) {
        this.checkTransaction();
        super.refresh(entity);
    }

    @Override
    public void flush() {
        this.checkTransaction();
        super.flush();
    }

    protected void checkTransaction() throws TransactionRequiredException {
        if (!this.getJtaFactory().isActiveTransaction()) {
            throw new TransactionRequiredException();
        }
    }

    class TransactionBinding
    implements Synchronization {
        TransactionBinding() {
        }

        public void afterCompletion(int status) {
            if (status != 3) {
                JtaEntityManager.this.clear();
            }
            JtaEntityManager.this.currentTxKey = null;
        }

        public void beforeCompletion() {
            JtaEntityManager.this.flush();
        }
    }
}

