/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import java.util.Iterator;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.MappingNamesHelper;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class DbRelationshipValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        DbRelationship rel = (DbRelationship)path.getObject();
        if (rel.getTargetEntity() == null) {
            validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " has no target entity.", path);
        } else if (rel.getJoins().size() == 0) {
            validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " has no joins.", path);
        } else {
            Iterator joins = rel.getJoins().iterator();
            while (joins.hasNext()) {
                DbJoin join = (DbJoin)joins.next();
                if (join.getSource() == null && join.getTarget() == null) {
                    validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " join has no source and target attributes selected.", path);
                    continue;
                }
                if (join.getSource() == null) {
                    validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " join has no source attribute selected.", path);
                    continue;
                }
                if (join.getTarget() != null) continue;
                validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " join has no target attribute selected.", path);
            }
        }
        if (Util.isEmptyString(rel.getName())) {
            validator.registerError("Unnamed DbRelationship.", path);
        } else if (rel.getSourceEntity().getAttribute(rel.getName()) != null) {
            validator.registerError("DbRelationship " + this.dbRelationshipIdentifier(rel) + " has the same name as one of DbAttributes", path);
        } else {
            MappingNamesHelper helper = MappingNamesHelper.getInstance();
            String invalidChars = helper.invalidCharsInDbPathComponent(rel.getName());
            if (invalidChars != null) {
                validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " name contains invalid characters: " + invalidChars, path);
            }
        }
    }

    public String dbRelationshipIdentifier(DbRelationship rel) {
        if (null == rel.getSourceEntity()) {
            return "<[null source entity]." + rel.getName() + ">";
        }
        return "<" + rel.getSourceEntity().getName() + "." + rel.getName() + ">";
    }
}

