/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyUtils;

public class BeanAccessor
implements Accessor {
    protected String propertyName;
    protected Method readMethod;
    protected Method writeMethod;
    protected Object nullValue;

    public BeanAccessor(Class objectClass, String propertyName, Class propertyType) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null objectClass");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName");
        }
        this.propertyName = propertyName;
        this.nullValue = PropertyUtils.defaultNullValueForType(propertyType);
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(propertyName, objectClass);
            this.readMethod = descriptor.getReadMethod();
            this.writeMethod = descriptor.getWriteMethod();
        }
        catch (IntrospectionException e) {
            throw new PropertyException("Invalid bean property: " + propertyName, this, (Object)e);
        }
    }

    public String getName() {
        return this.propertyName;
    }

    public Object getValue(Object object) throws PropertyException {
        if (this.readMethod == null) {
            throw new PropertyException("Property '" + this.propertyName + "' is not readable", this, object);
        }
        try {
            return this.readMethod.invoke(object, null);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading property: " + this.propertyName, this, object, th);
        }
    }

    public void setValue(Object object, Object newValue) throws PropertyException {
        if (this.writeMethod == null) {
            throw new PropertyException("Property '" + this.propertyName + "' is not writable", this, object);
        }
        if (newValue == null) {
            newValue = this.nullValue;
        }
        try {
            this.writeMethod.invoke(object, newValue);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading property: " + this.propertyName, this, object, th);
        }
    }
}

