/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.AbstractCallback;
import org.apache.cayenne.util.Util;

class CallbackOnListener
extends AbstractCallback {
    private Method callbackMethod;
    private Object listener;

    CallbackOnListener(Object listener, String methodName) throws IllegalArgumentException {
        this(listener, methodName, Object.class);
    }

    CallbackOnListener(Object listener, String methodName, Class entityType) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        this.callbackMethod = this.findMethod(listener.getClass(), methodName, entityType);
        this.listener = listener;
    }

    public void performCallback(Object entity) {
        try {
            this.callbackMethod.invoke(this.listener, entity);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error invoking entity listener callback method " + this.callbackMethod.getName(), e);
        }
    }

    private Method findMethod(Class objectClass, String methodName, Class entityType) throws IllegalArgumentException {
        Method[] methods = objectClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            int modifiers = methods[i].getModifiers();
            Class<?>[] parameters = methods[i].getParameterTypes();
            if (Modifier.isStatic(modifiers) || !Void.TYPE.isAssignableFrom(methods[i].getReturnType()) || parameters.length != 1 || !parameters[0].isAssignableFrom(entityType)) continue;
            if (!Util.isAccessible(methods[i])) {
                methods[i].setAccessible(true);
            }
            return methods[i];
        }
        throw new IllegalArgumentException("Class " + objectClass.getName() + " has no valid listener callback method '" + methodName + "'");
    }
}

