/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorFactory;
import org.apache.cayenne.reflect.LazyClassDescriptorDecorator;

public class ClassDescriptorMap {
    protected EntityResolver resolver;
    protected Map descriptors = new HashMap();
    protected List factories;

    public ClassDescriptorMap(EntityResolver resolver) {
        this.resolver = resolver;
        this.factories = new ArrayList();
    }

    public EntityResolver getResolver() {
        return this.resolver;
    }

    public void addFactory(ClassDescriptorFactory factory) {
        this.factories.add(factory);
    }

    public void removeFactory(ClassDescriptorFactory factory) {
        this.factories.remove(factory);
    }

    public void clearFactories() {
        this.factories.clear();
    }

    public void clearDescriptors() {
        this.descriptors.clear();
    }

    public void removeDescriptor(String entityName) {
        this.descriptors.remove(entityName);
    }

    public void addDescriptor(String entityName, ClassDescriptor descriptor) {
        if (descriptor == null) {
            this.removeDescriptor(entityName);
        } else {
            this.descriptors.put(entityName, descriptor);
        }
    }

    public ClassDescriptor getDescriptor(String entityName) {
        if (entityName == null) {
            throw new NullPointerException("Null 'entityName'");
        }
        ClassDescriptor cached = (ClassDescriptor)this.descriptors.get(entityName);
        if (cached != null) {
            return cached;
        }
        return this.createProxyDescriptor(entityName);
    }

    protected ClassDescriptor createProxyDescriptor(String entityName) {
        LazyClassDescriptorDecorator descriptor = new LazyClassDescriptorDecorator(this, entityName);
        this.addDescriptor(entityName, descriptor);
        return descriptor;
    }

    protected ClassDescriptor createDescriptor(String entityName) {
        ListIterator it = this.factories.listIterator(this.factories.size());
        while (it.hasPrevious()) {
            ClassDescriptorFactory factory = (ClassDescriptorFactory)it.previous();
            ClassDescriptor descriptor = factory.getDescriptor(entityName);
            if (descriptor == null) continue;
            return descriptor;
        }
        throw new CayenneRuntimeException("Failed to create descriptor for entity: " + entityName);
    }
}

