/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.PropertyException;

public class EmbeddedFieldAccessor
implements Accessor {
    protected String propertyPath;
    protected Accessor embeddedAccessor;
    protected Accessor embeddableAccessor;
    protected Class embeddedClass;

    public EmbeddedFieldAccessor(Class embeddableClass, Accessor embeddedAccessor, Accessor embeddableAccessor) {
        this.propertyPath = embeddedAccessor.getName() + "." + embeddableAccessor.getName();
        this.embeddedClass = embeddableClass;
        this.embeddableAccessor = embeddableAccessor;
        this.embeddedAccessor = embeddedAccessor;
    }

    public String getName() {
        return this.propertyPath;
    }

    public Object getValue(Object object) throws PropertyException {
        return this.embeddableAccessor.getValue(this.getEmbeddable(object));
    }

    public void setValue(Object object, Object newValue) throws PropertyException {
        this.embeddableAccessor.setValue(this.getEmbeddable(object), newValue);
    }

    protected Object getEmbeddable(Object owner) {
        Object embeddable = this.embeddedAccessor.getValue(owner);
        if (embeddable == null) {
            embeddable = this.createEmbeddable();
            this.embeddedAccessor.setValue(owner, embeddable);
        }
        return embeddable;
    }

    protected Object createEmbeddable() {
        if (this.embeddedClass == null) {
            throw new NullPointerException("Null embedded objectClass. Accessor wasn't initialized properly.");
        }
        try {
            return this.embeddedClass.newInstance();
        }
        catch (Throwable e) {
            throw new CayenneRuntimeException("Error creating embedded object of class '" + this.embeddedClass.getName() + "'", e);
        }
    }
}

