/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cayenne.gen.DefaultClassGenerator;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.tools.ILog;
import org.apache.cayenne.tools.NamePatternMatcher;
import org.apache.cayenne.util.Util;
import org.xml.sax.InputSource;

class CayenneGeneratorUtil {
    protected ILog logger;
    protected MapLoader mapLoader;
    protected File map;
    protected File[] additionalMaps;
    protected DefaultClassGenerator generator;
    protected String includeEntitiesPattern;
    protected String excludeEntitiesPattern;

    CayenneGeneratorUtil() {
    }

    public DataMap loadDataMap(File mapName) throws Exception {
        InputSource in = new InputSource(mapName.toURL().toString());
        if (this.mapLoader == null) {
            this.mapLoader = new MapLoader();
        }
        return this.mapLoader.loadDataMap(in);
    }

    public DataMap loadDataMap() throws Exception {
        return this.loadDataMap(this.map);
    }

    protected DataMap[] loadAdditionalDataMaps() throws Exception {
        if (null == this.additionalMaps) {
            return new DataMap[0];
        }
        DataMap[] dataMaps = new DataMap[this.additionalMaps.length];
        for (int i = 0; i < this.additionalMaps.length; ++i) {
            dataMaps[i] = this.loadDataMap(this.additionalMaps[i]);
        }
        return dataMaps;
    }

    public void processMap() throws Exception {
        DataMap dataMap = this.loadDataMap();
        DataMap[] additionalDataMaps = this.loadAdditionalDataMaps();
        EntityResolver entityResolver = new EntityResolver(Collections.singleton(dataMap));
        dataMap.setNamespace(entityResolver);
        for (int i = 0; i < additionalDataMaps.length; ++i) {
            entityResolver.addDataMap(additionalDataMaps[i]);
            additionalDataMaps[i].setNamespace(entityResolver);
        }
        Collection allEntities = dataMap.getObjEntities();
        ArrayList<ObjEntity> filteredEntities = new ArrayList<ObjEntity>(allEntities.size());
        if (this.generator.isClient()) {
            if (dataMap.isClientSupported()) {
                Iterator it = allEntities.iterator();
                while (it.hasNext()) {
                    ObjEntity entity = (ObjEntity)it.next();
                    if (!entity.isClientAllowed()) continue;
                    filteredEntities.add(entity);
                }
            }
        } else {
            filteredEntities.addAll(allEntities);
        }
        NamePatternMatcher namePatternMatcher = new NamePatternMatcher(this.logger, this.includeEntitiesPattern, this.excludeEntitiesPattern);
        namePatternMatcher.filter(filteredEntities);
        this.generator.setTimestamp(this.map.lastModified());
        this.generator.setDataMap(dataMap);
        this.generator.setObjEntities(filteredEntities);
        this.generator.validateAttributes();
        this.generator.execute();
    }

    public void execute() throws Exception {
        try {
            this.processMap();
        }
        catch (Throwable th) {
            th = Util.unwindException(th);
            String thMessage = th.getLocalizedMessage();
            String message = "Error generating classes: ";
            message = message + (!Util.isEmptyString(thMessage) ? thMessage : th.getClass().getName());
            this.logger.log(message);
            throw new Exception(message, th);
        }
    }

    public void setAdditionalMaps(File[] additionalMaps) {
        this.additionalMaps = additionalMaps;
    }

    public void setExcludeEntitiesPattern(String excludeEntitiesPattern) {
        this.excludeEntitiesPattern = excludeEntitiesPattern;
    }

    public void setGenerator(DefaultClassGenerator generator) {
        this.generator = generator;
    }

    public void setIncludeEntitiesPattern(String includeEntitiesPattern) {
        this.includeEntitiesPattern = includeEntitiesPattern;
    }

    public void setLogger(ILog logger) {
        this.logger = logger;
    }

    public void setMap(File map) {
        this.map = map;
    }
}

