/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.ObjectContextGraphAction;

class CayenneContextGraphAction
extends ObjectContextGraphAction {
    static final ThreadLocal<Boolean> arcChangeInProcess = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    CayenneContextGraphAction(ObjectContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleArcPropertyChange(Persistent object, ArcProperty property, Object oldValue, Object newValue) {
        if (this.isArchChangeInProcess()) {
            return;
        }
        this.setArcChangeInProcess(true);
        try {
            if (oldValue instanceof Persistent) {
                this.context.getGraphManager().arcDeleted(object.getObjectId(), ((Persistent)oldValue).getObjectId(), property.getName());
                this.unsetReverse(property, object, (Persistent)oldValue);
                this.markAsDirty(object);
            }
            if (newValue instanceof Persistent) {
                this.context.getGraphManager().arcCreated(object.getObjectId(), ((Persistent)newValue).getObjectId(), property.getName());
                this.setReverse(property, object, (Persistent)newValue);
                this.markAsDirty(object);
            }
        }
        finally {
            this.setArcChangeInProcess(false);
        }
    }

    protected void handleSimplePropertyChange(Persistent object, String propertyName, Object oldValue, Object newValue) {
        this.context.getGraphManager().nodePropertyChanged(object.getObjectId(), propertyName, oldValue, newValue);
        this.markAsDirty(object);
    }

    boolean isArchChangeInProcess() {
        return arcChangeInProcess.get();
    }

    void setArcChangeInProcess(boolean flag) {
        arcChangeInProcess.set(flag);
    }

    private void setReverse(ArcProperty property, final Persistent sourceObject, final Persistent targetObject) {
        ArcProperty reverseArc = property.getComplimentaryReverseArc();
        if (reverseArc != null) {
            reverseArc.visit(new PropertyVisitor(){

                public boolean visitToMany(ToManyProperty property) {
                    property.addTarget(targetObject, sourceObject, false);
                    return false;
                }

                public boolean visitToOne(ToOneProperty property) {
                    property.setTarget(targetObject, sourceObject, false);
                    return false;
                }

                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }
            });
            this.context.getGraphManager().arcCreated(targetObject.getObjectId(), sourceObject.getObjectId(), reverseArc.getName());
            this.markAsDirty(targetObject);
        }
    }

    private void unsetReverse(ArcProperty property, Persistent sourceObject, Persistent targetObject) {
        ArcProperty reverseArc = property.getComplimentaryReverseArc();
        if (reverseArc != null) {
            reverseArc.writePropertyDirectly(targetObject, sourceObject, null);
            this.context.getGraphManager().arcDeleted(targetObject.getObjectId(), sourceObject.getObjectId(), reverseArc.getName());
            this.markAsDirty(targetObject);
        }
    }
}

