/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.query.RelationshipQuery;

public class ToOneFault
extends Fault {
    public Object resolveFault(Persistent sourceObject, String relationshipName) {
        ObjectDiff diff;
        int state = sourceObject.getPersistenceState();
        if (state == 2) {
            return null;
        }
        Object target = this.doResolveFault(sourceObject, relationshipName);
        ObjectContext context = sourceObject.getObjectContext();
        if ((state == 4 || state == 6) && context instanceof DataContext && (diff = ((DataContext)context).getObjectStore().getChangesByObjectId().get(sourceObject.getObjectId())) != null) {
            diff.updateArcSnapshot(relationshipName, (Persistent)target);
        }
        return target;
    }

    Object doResolveFault(Persistent sourceObject, String relationshipName) {
        RelationshipQuery query = new RelationshipQuery(sourceObject.getObjectId(), relationshipName, false);
        List objects = sourceObject.getObjectContext().performQuery(query);
        if (objects.isEmpty()) {
            return null;
        }
        if (objects.size() == 1) {
            return objects.get(0);
        }
        throw new CayenneRuntimeException("Error resolving to-one fault. More than one object found. Source Id: " + sourceObject.getObjectId() + ", relationship: " + relationshipName);
    }
}

