/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import org.apache.cayenne.access.jdbc.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.jdbc.EJBQLPathTranslator;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLExpressionVisitor;
import org.apache.cayenne.ejbql.parser.EJBQLAggregateColumn;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;

class EJBQLAggregateColumnTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private String attributeType;

    EJBQLAggregateColumnTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    public boolean visitCount(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new CountColumnVisitor());
        return false;
    }

    public boolean visitAverage(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new FieldPathTranslator());
        return false;
    }

    public boolean visitMax(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new FieldPathTranslator());
        return false;
    }

    public boolean visitMin(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new FieldPathTranslator());
        return false;
    }

    public boolean visitSum(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new FieldPathTranslator());
        return false;
    }

    private void visitAggregateColumn(EJBQLAggregateColumn column, EJBQLExpressionVisitor pathVisitor) {
        if (this.context.isAppendingResultColumns()) {
            this.context.append(" #result('");
        } else {
            this.context.append(' ');
        }
        this.context.append(column.getFunction()).append('(');
        column.visit(pathVisitor);
        this.context.append(')');
        if (this.context.isAppendingResultColumns()) {
            this.context.append("' '").append(column.getJavaType(this.attributeType)).append("' '").append(this.context.nextColumnAlias()).append("')");
        }
    }

    class CountColumnVisitor
    extends EJBQLBaseVisitor {
        CountColumnVisitor() {
        }

        public boolean visitDistinct(EJBQLExpression expression) {
            EJBQLAggregateColumnTranslator.this.context.append("DISTINCT ");
            return true;
        }

        public boolean visitIdentifier(EJBQLExpression expression) {
            EJBQLAggregateColumnTranslator.this.context.append('*');
            return false;
        }

        public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
            expression.visit(new FieldPathTranslator());
            return false;
        }
    }

    class FieldPathTranslator
    extends EJBQLPathTranslator {
        FieldPathTranslator() {
            super(EJBQLAggregateColumnTranslator.this.context);
        }

        public boolean visitDistinct(EJBQLExpression expression) {
            EJBQLAggregateColumnTranslator.this.context.append("DISTINCT ");
            return true;
        }

        protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
            throw new EJBQLException("Can't use multi-column paths in column clause");
        }

        protected void processTerminatingAttribute(ObjAttribute attribute) {
            EJBQLAggregateColumnTranslator.this.attributeType = attribute.getType();
            DbEntity table = this.currentEntity.getDbEntity();
            String alias = this.lastAlias != null ? this.lastAlias : EJBQLAggregateColumnTranslator.this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
            EJBQLAggregateColumnTranslator.this.context.append(alias).append('.').append(attribute.getDbAttributeName());
        }
    }
}

