/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectMatchTranslator {
    protected Map<String, DbAttribute> attributes;
    protected Map<String, Object> values;
    protected String operation;
    protected Expression expression;
    protected DbRelationship relationship;

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void reset() {
        this.attributes = null;
        this.values = null;
        this.operation = null;
        this.expression = null;
        this.relationship = null;
    }

    public void setRelationship(DbRelationship rel) {
        this.relationship = rel;
        this.attributes = new HashMap<String, DbAttribute>(rel.getJoins().size() * 2);
        if (rel.isToMany() || !rel.isToPK()) {
            DbEntity ent = (DbEntity)rel.getTargetEntity();
            for (DbAttribute pkAttr : ent.getPrimaryKeys()) {
                this.attributes.put(pkAttr.getName(), pkAttr);
            }
        } else {
            for (DbJoin join : rel.getJoins()) {
                this.attributes.put(join.getTargetName(), join.getSource());
            }
        }
    }

    public void setDataObject(Persistent obj) {
        if (obj == null) {
            this.values = Collections.EMPTY_MAP;
            return;
        }
        this.setObjectId(obj.getObjectId());
    }

    public void setObjectId(ObjectId id) {
        if (id == null) {
            throw new CayenneRuntimeException("Null ObjectId, probably an attempt to use TRANSIENT object as a query parameter.");
        }
        if (id.isTemporary()) {
            throw new CayenneRuntimeException("Temporary id, probably an attempt to use NEW object as a query parameter.");
        }
        this.values = id.getIdSnapshot();
    }

    public Iterator<String> keys() {
        if (this.attributes == null) {
            throw new IllegalStateException("An attempt to use uninitialized DataObjectMatchTranslator: [attributes: null, values: " + this.values + "]");
        }
        return this.attributes.keySet().iterator();
    }

    public DbRelationship getRelationship() {
        return this.relationship;
    }

    public DbAttribute getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Object getValue(String key) {
        return this.values.get(key);
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }
}

