/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;

public class DefaultOperationObserver
implements OperationObserver {
    protected List globalExceptions = new ArrayList();
    protected Map queryExceptions = new HashMap();

    public void printExceptions(PrintWriter out) {
        if (this.globalExceptions.size() > 0) {
            if (this.globalExceptions.size() == 1) {
                out.println("Global Exception:");
            } else {
                out.println("Global Exceptions:");
            }
            for (Throwable th : this.globalExceptions) {
                th.printStackTrace(out);
            }
        }
        if (this.queryExceptions.size() > 0) {
            if (this.queryExceptions.size() == 1) {
                out.println("Query Exception:");
            } else {
                out.println("Query Exceptions:");
            }
            Iterator<Object> it = this.queryExceptions.keySet().iterator();
            while (it.hasNext()) {
                Throwable th;
                th = (Throwable)this.queryExceptions.get(it.next());
                th.printStackTrace(out);
            }
        }
    }

    public List getGlobalExceptions() {
        return this.globalExceptions;
    }

    public Map getQueryExceptions() {
        return this.queryExceptions;
    }

    public boolean hasExceptions() {
        return this.globalExceptions.size() > 0 || this.queryExceptions.size() > 0;
    }

    public void nextCount(Query query, int resultCount) {
    }

    public void nextBatchCount(Query query, int[] resultCount) {
    }

    public void nextDataRows(Query query, List dataRows) {
    }

    public void nextDataRows(Query query, ResultIterator it) {
        if (it != null) {
            try {
                it.close();
            }
            catch (CayenneException ex) {
                this.nextQueryException(query, ex);
            }
        }
    }

    public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
        if (keysIterator != null) {
            try {
                keysIterator.close();
            }
            catch (CayenneException ex) {
                this.nextQueryException(query, ex);
            }
        }
    }

    public void nextQueryException(Query query, Exception ex) {
        this.queryExceptions.put(query, Util.unwindException(ex));
    }

    public void nextGlobalException(Exception ex) {
        this.globalExceptions.add(Util.unwindException(ex));
    }

    public boolean isIteratedResult() {
        return false;
    }
}

