/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigStatus {
    protected List<String> otherFailures = new ArrayList<String>();
    protected Map<String, String> failedMaps = new HashMap<String, String>();
    protected Map<String, String> failedAdapters = new HashMap<String, String>();
    protected Map<String, String> failedDataSources = new HashMap<String, String>();
    protected List<String> failedMapRefs = new ArrayList<String>();
    protected Map<String, Object> messages = new HashMap<String, Object>();

    public void addFailedMap(String name, String location, Object extraMessage) {
        this.failedMaps.put(name, location);
        if (extraMessage != null) {
            this.messages.put(this.getMapMessageKey(name, location), extraMessage);
        }
    }

    public void addFailedAdapter(String name, String location, String extraMessage) {
        this.failedAdapters.put(name, location);
        if (extraMessage != null) {
            this.messages.put(this.getAdapterMessageKey(name, location), extraMessage);
        }
    }

    public void addFailedDataSource(String name, String location, String extraMessage) {
        this.failedDataSources.put(name, location);
        if (extraMessage != null) {
            this.messages.put(this.getDataSourceMessageKey(name, location), extraMessage);
        }
    }

    public void addFailedMapRefs(String name, String extraMessage) {
        this.failedMapRefs.add(name);
        if (extraMessage != null) {
            this.messages.put(this.getMapRefMessageKey(name), extraMessage);
        }
    }

    protected String getMapMessageKey(String name, String location) {
        return "map:" + name + ":" + location;
    }

    protected String getAdapterMessageKey(String name, String location) {
        return "adapter:" + name + ":" + location;
    }

    protected String getDataSourceMessageKey(String name, String location) {
        return "dataSource:" + name + ":" + location;
    }

    protected String getMapRefMessageKey(String name) {
        return "map-ref:" + name;
    }

    public String describeFailures() {
        Object message;
        String location;
        if (!this.hasFailures()) {
            return "[No failures]";
        }
        StringBuffer buf = new StringBuffer();
        for (String name : this.failedMaps.keySet()) {
            location = this.failedMaps.get(name);
            message = this.messages.get(this.getMapMessageKey(name, location));
            buf.append("\n\tdomain.map.name=").append(name).append(", domain.map.location=").append(location);
            if (message == null) continue;
            buf.append(", reason: ").append(message);
        }
        for (String node : this.failedAdapters.keySet()) {
            String adapter = this.failedAdapters.get(node);
            message = this.messages.get(this.getAdapterMessageKey(node, adapter));
            buf.append("\n\tdomain.node.name=").append(node).append(", domain.node.adapter=").append(adapter);
            if (message == null) continue;
            buf.append(", reason: ").append(message);
        }
        for (String node : this.failedDataSources.keySet()) {
            location = this.failedDataSources.get(node);
            message = this.messages.get(this.getDataSourceMessageKey(node, location));
            buf.append("\n\tdomain.node.name=").append(node).append(", domain.node.datasource=").append(location);
            if (message == null) continue;
            buf.append(", reason: ").append(message);
        }
        for (String mapName : this.failedMapRefs) {
            if (this.failedMaps.get(mapName) != null) continue;
            buf.append("\n\tdomain.node.map-ref.name=").append(mapName);
            Object message2 = this.messages.get(this.getMapRefMessageKey(mapName));
            if (message2 == null) continue;
            buf.append(", reason: ").append(message2);
        }
        return buf.toString();
    }

    public List<String> getOtherFailures() {
        return this.otherFailures;
    }

    public List<String> getFailedMapRefs() {
        return this.failedMapRefs;
    }

    public Map<String, String> getFailedMaps() {
        return this.failedMaps;
    }

    public Map<String, String> getFailedDataSources() {
        return this.failedDataSources;
    }

    public Map<String, String> getFailedAdapters() {
        return this.failedAdapters;
    }

    public boolean hasFailures() {
        return this.failedMaps.size() > 0 || this.failedDataSources.size() > 0 || this.failedAdapters.size() > 0 || this.failedMapRefs.size() > 0 || this.otherFailures.size() > 0;
    }
}

