/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.apache.cayenne.conn.ConnectionWrapper;

public class PooledConnectionImpl
implements PooledConnection {
    private Connection connectionObj;
    private List connectionEventListeners = Collections.synchronizedList(new ArrayList(10));
    private boolean hadErrors;
    private DataSource connectionSource;
    private String userName;
    private String password;

    protected PooledConnectionImpl() {
    }

    public PooledConnectionImpl(DataSource connectionSource, String userName, String password) {
        this();
        this.connectionSource = connectionSource;
        this.userName = userName;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() throws SQLException {
        if (this.connectionObj != null) {
            try {
                this.connectionObj.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.connectionObj = null;
            }
        }
        this.connectionObj = this.userName != null ? this.connectionSource.getConnection(this.userName, this.password) : this.connectionSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener listener) {
        List list = this.connectionEventListeners;
        synchronized (list) {
            if (!this.connectionEventListeners.contains(listener)) {
                this.connectionEventListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        List list = this.connectionEventListeners;
        synchronized (list) {
            this.connectionEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        List list = this.connectionEventListeners;
        synchronized (list) {
            this.connectionEventListeners.clear();
        }
        if (this.connectionObj != null) {
            try {
                this.connectionObj.close();
            }
            finally {
                this.connectionObj = null;
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.connectionObj == null) {
            this.reconnect();
        }
        if (!this.connectionObj.getAutoCommit()) {
            try {
                this.connectionObj.setAutoCommit(true);
            }
            catch (SQLException sqlEx) {
                ConnectionWrapper.sybaseAutoCommitPatch(this.connectionObj, sqlEx, true);
            }
        }
        this.connectionObj.clearWarnings();
        return new ConnectionWrapper(this.connectionObj, this);
    }

    protected void returnConnectionToThePool() throws SQLException {
        if (this.hadErrors) {
            this.close();
        } else {
            this.connectionClosedNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionErrorNotification(SQLException exception) {
        this.hadErrors = true;
        List list = this.connectionEventListeners;
        synchronized (list) {
            if (this.connectionEventListeners.size() == 0) {
                return;
            }
            ConnectionEvent closedEvent = new ConnectionEvent(this, exception);
            for (ConnectionEventListener nextListener : this.connectionEventListeners) {
                nextListener.connectionErrorOccurred(closedEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosedNotification() {
        List list = this.connectionEventListeners;
        synchronized (list) {
            if (this.connectionEventListeners.size() == 0) {
                return;
            }
            ConnectionEvent closedEvent = new ConnectionEvent(this);
            for (ConnectionEventListener nextListener : this.connectionEventListeners) {
                nextListener.connectionClosed(closedEvent);
            }
        }
    }
}

