/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.DropRelationshipToDb;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.SetColumnTypeToDb;

public class MySQLMergerFactory
extends MergerFactory {
    public MergerToken createSetColumnTypeToDb(final DbEntity entity, DbAttribute columnOriginal, final DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew){

            protected void appendPrefix(StringBuffer sqlBuffer) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(entity.getFullyQualifiedName());
                sqlBuffer.append(" MODIFY ");
                sqlBuffer.append(columnNew.getName());
                sqlBuffer.append(" ");
            }
        };
    }

    public MergerToken createDropRelationshipToDb(final DbEntity entity, DbRelationship rel) {
        return new DropRelationshipToDb(entity, rel){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                String fkName = this.getFkName();
                if (fkName == null) {
                    return Collections.emptyList();
                }
                StringBuilder buf = new StringBuilder();
                buf.append("ALTER TABLE ");
                buf.append(entity.getFullyQualifiedName());
                buf.append(" DROP FOREIGN KEY ");
                buf.append(fkName);
                return Collections.singletonList(buf.toString());
            }
        };
    }
}

