/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import javax.persistence.DiscriminatorType;
import javax.persistence.EnumType;
import javax.persistence.InheritanceType;
import javax.persistence.TemporalType;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.conf.AnnotationPrototypes;
import org.apache.cayenne.jpa.conf.EntityMapLoaderContext;
import org.apache.cayenne.jpa.map.AccessType;
import org.apache.cayenne.jpa.map.JpaAbstractEntity;
import org.apache.cayenne.jpa.map.JpaAttribute;
import org.apache.cayenne.jpa.map.JpaAttributes;
import org.apache.cayenne.jpa.map.JpaBasic;
import org.apache.cayenne.jpa.map.JpaClassDescriptor;
import org.apache.cayenne.jpa.map.JpaColumn;
import org.apache.cayenne.jpa.map.JpaDiscriminatorColumn;
import org.apache.cayenne.jpa.map.JpaEmbeddable;
import org.apache.cayenne.jpa.map.JpaEntity;
import org.apache.cayenne.jpa.map.JpaEntityMap;
import org.apache.cayenne.jpa.map.JpaId;
import org.apache.cayenne.jpa.map.JpaJoinColumn;
import org.apache.cayenne.jpa.map.JpaManagedClass;
import org.apache.cayenne.jpa.map.JpaManyToMany;
import org.apache.cayenne.jpa.map.JpaManyToOne;
import org.apache.cayenne.jpa.map.JpaMappedSuperclass;
import org.apache.cayenne.jpa.map.JpaOneToMany;
import org.apache.cayenne.jpa.map.JpaOneToOne;
import org.apache.cayenne.jpa.map.JpaPrimaryKeyJoinColumn;
import org.apache.cayenne.jpa.map.JpaPropertyDescriptor;
import org.apache.cayenne.jpa.map.JpaRelationship;
import org.apache.cayenne.jpa.map.JpaSecondaryTable;
import org.apache.cayenne.jpa.map.JpaTable;
import org.apache.cayenne.jpa.map.JpaVersion;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.util.BaseTreeVisitor;
import org.apache.cayenne.util.HierarchicalTreeVisitor;
import org.apache.cayenne.util.TraversalUtil;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.SimpleValidationFailure;

public class EntityMapDefaultsProcessor {
    protected HierarchicalTreeVisitor visitor;
    protected transient EntityMapLoaderContext context;

    public void applyDefaults(EntityMapLoaderContext context) throws JpaProviderException {
        this.context = context;
        if (this.visitor == null) {
            this.visitor = this.createVisitor();
        }
        TraversalUtil.traverse(context.getEntityMap(), this.visitor);
    }

    protected HierarchicalTreeVisitor createVisitor() {
        return new EntityMapVisitor();
    }

    class RelationshipVisitor
    extends BaseTreeVisitor {
        RelationshipVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaRelationship relationship = (JpaRelationship)path.getObject();
            if (Util.isEmptyString(relationship.getTargetEntityName())) {
                JpaManagedClass relationshipOwner = path.firstInstanceOf(JpaManagedClass.class);
                String name = relationship.getName();
                JpaClassDescriptor srcDescriptor = relationshipOwner.getClassDescriptor();
                JpaPropertyDescriptor property = srcDescriptor.getProperty(name);
                Class<?> targetEntityType = property.getTargetEntityType();
                if (targetEntityType == null) {
                    EntityMapDefaultsProcessor.this.context.recordConflict(new SimpleValidationFailure(property.getMember(), "Undefined target entity type: " + name));
                    return false;
                }
                relationship.setTargetEntityName(targetEntityType.getName());
            }
            return true;
        }
    }

    final class OneToOneVisitor
    extends RelationshipVisitor {
        OneToOneVisitor() {
            this.addChildVisitor(JpaJoinColumn.class, new JoinColumnVisitor());
        }

        public boolean onStartNode(ProjectPath path) {
            if (!super.onStartNode(path)) {
                return false;
            }
            JpaOneToOne oneToOne = (JpaOneToOne)path.getObject();
            Collection<JpaJoinColumn> joinColumns = oneToOne.getJoinColumns();
            String mappedBy = oneToOne.getMappedBy();
            if (joinColumns.isEmpty() && mappedBy == null) {
                joinColumns.add(new JpaJoinColumn(AnnotationPrototypes.getJoinColumn()));
            }
            return true;
        }
    }

    final class ManyToOneVisitor
    extends RelationshipVisitor {
        ManyToOneVisitor() {
            this.addChildVisitor(JpaJoinColumn.class, new JoinColumnVisitor());
        }

        public boolean onStartNode(ProjectPath path) {
            if (!super.onStartNode(path)) {
                return false;
            }
            JpaManyToOne manyToOne = (JpaManyToOne)path.getObject();
            Collection<JpaJoinColumn> joinColumns = manyToOne.getJoinColumns();
            if (joinColumns.isEmpty()) {
                joinColumns.add(new JpaJoinColumn(AnnotationPrototypes.getJoinColumn()));
            }
            return true;
        }
    }

    final class MappedSuperclassVisitor
    extends AbstractEntityVisitor {
        MappedSuperclassVisitor() {
        }
    }

    final class JoinColumnVisitor
    extends BaseTreeVisitor {
        JoinColumnVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaEntityMap map;
            JpaEntity target;
            JpaRelationship relationship = (JpaRelationship)path.getObjectParent();
            JpaJoinColumn column = (JpaJoinColumn)path.getObject();
            if (column.getTable() == null) {
                JpaEntity entity = path.firstInstanceOf(JpaEntity.class);
                column.setTable(entity.getTable().getName());
            }
            if ((target = (map = path.firstInstanceOf(JpaEntityMap.class)).entityForClass(relationship.getTargetEntityName())) == null) {
                EntityMapDefaultsProcessor.this.context.recordConflict(new SimpleValidationFailure(relationship, "Invalid relationship target " + relationship.getTargetEntityName()));
            } else if (target.getAttributes() == null || target.getAttributes().getIds().isEmpty()) {
                EntityMapDefaultsProcessor.this.context.recordConflict(new SimpleValidationFailure(target, "Relationship target has no PK defined: " + relationship.getTargetEntityName()));
            } else if (target.getAttributes().getIds().size() > 1) {
                EntityMapDefaultsProcessor.this.context.recordConflict(new SimpleValidationFailure(relationship, "Defaults for compound FK are not implemented."));
            } else {
                JpaId id = target.getAttributes().getIds().iterator().next();
                String pkName = id.getColumn() != null ? id.getColumn().getName() : id.getName();
                column.setName(relationship.getName() + '_' + pkName);
                column.setReferencedColumnName(id.getColumn() != null ? id.getColumn().getName() : id.getName());
            }
            return true;
        }
    }

    final class IdVisitor
    extends BaseTreeVisitor {
        IdVisitor() {
            this.addChildVisitor(JpaColumn.class, new ColumnVisitor());
        }

        public boolean onStartNode(ProjectPath path) {
            JpaId id = (JpaId)path.getObject();
            if (id.getColumn() == null) {
                JpaColumn column = new JpaColumn(AnnotationPrototypes.getColumn());
                column.setName(id.getName());
                JpaEntity entity = path.firstInstanceOf(JpaEntity.class);
                column.setTable(entity.getTable().getName());
                id.setColumn(column);
            }
            return true;
        }
    }

    final class EntityVisitor
    extends AbstractEntityVisitor {
        EntityVisitor() {
            this.addChildVisitor(JpaDiscriminatorColumn.class, new DiscriminatorColumnVisitor());
        }

        public boolean onStartNode(ProjectPath path) {
            if (super.onStartNode(path)) {
                JpaEntity entity = (JpaEntity)path.getObject();
                if (entity.getInheritance() != null && entity.getInheritance().getStrategy() == null) {
                    entity.getInheritance().setStrategy(InheritanceType.SINGLE_TABLE);
                }
                if (entity.getName() == null) {
                    String fqName = entity.getClassName();
                    int split = fqName.lastIndexOf(46);
                    entity.setName(split > 0 ? fqName.substring(split + 1) : fqName);
                }
                if ((entity.getInheritance() != null || entity.lookupInheritanceStrategy() != InheritanceType.SINGLE_TABLE) && entity.getTable() == null) {
                    JpaTable table = new JpaTable(AnnotationPrototypes.getTable());
                    table.setName(entity.getName());
                    entity.setTable(table);
                }
                return true;
            }
            return false;
        }

        public void onFinishNode(ProjectPath path) {
            JpaEntity entity = (JpaEntity)path.getObject();
            for (JpaSecondaryTable table : entity.getSecondaryTables()) {
                if (table.getPrimaryKeyJoinColumns().isEmpty()) {
                    for (JpaId id : entity.getAttributes().getIds()) {
                        JpaPrimaryKeyJoinColumn joinColumn = new JpaPrimaryKeyJoinColumn();
                        joinColumn.setName(id.getColumn().getName());
                        joinColumn.setReferencedColumnName(joinColumn.getName());
                        table.getPrimaryKeyJoinColumns().add(joinColumn);
                    }
                    continue;
                }
                for (JpaPrimaryKeyJoinColumn joinColumn : table.getPrimaryKeyJoinColumns()) {
                    if (joinColumn.getReferencedColumnName() != null || entity.getAttributes().getIds().size() != 1) continue;
                    JpaId id = entity.getAttributes().getIds().iterator().next();
                    joinColumn.setReferencedColumnName(id.getColumn().getName());
                }
            }
            JpaDiscriminatorColumn discriminator = entity.lookupDiscriminatorColumn();
            if (discriminator != null && entity.getDiscriminatorValue() == null) {
                switch (discriminator.getDiscriminatorType()) {
                    case STRING: {
                        entity.setDiscriminatorValue(entity.getName());
                        break;
                    }
                    default: {
                        EntityMapDefaultsProcessor.this.context.recordConflict(new SimpleValidationFailure(entity, "Can't guess default discriminator value for non-String discriminator column: " + discriminator.getName()));
                    }
                }
            }
        }
    }

    final class EmbeddableVisitor
    extends BaseTreeVisitor {
        EmbeddableVisitor() {
            BaseTreeVisitor attributeVisitor = new BaseTreeVisitor();
            attributeVisitor.addChildVisitor(JpaBasic.class, new EmbeddableBasicVisitor());
            this.addChildVisitor(JpaAttributes.class, attributeVisitor);
        }
    }

    final class EntityMapVisitor
    extends BaseTreeVisitor {
        EntityMapVisitor() {
            this.addChildVisitor(JpaEntity.class, new EntityVisitor());
            this.addChildVisitor(JpaMappedSuperclass.class, new MappedSuperclassVisitor());
            this.addChildVisitor(JpaEmbeddable.class, new EmbeddableVisitor());
        }

        public boolean onStartNode(ProjectPath path) {
            JpaEntityMap entityMap = (JpaEntityMap)path.getObject();
            entityMap.setAccess(AccessType.FIELD);
            return true;
        }
    }

    final class ColumnVisitor
    extends BaseTreeVisitor {
        ColumnVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaEntity entity;
            JpaColumn column = (JpaColumn)path.getObject();
            JpaAttribute parent = path.firstInstanceOf(JpaAttribute.class);
            if (column.getName() == null) {
                column.setName(parent.getName());
            }
            if (column.getTable() == null && (entity = path.firstInstanceOf(JpaEntity.class)) != null) {
                column.setTable(entity.lookupTable().getName());
            }
            if (parent.getPropertyDescriptor().isStringType()) {
                if (column.getLength() <= 0) {
                    column.setLength(255);
                }
            } else {
                column.setLength(-1);
            }
            return true;
        }
    }

    final class DiscriminatorColumnVisitor
    extends BaseTreeVisitor {
        DiscriminatorColumnVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaDiscriminatorColumn column = (JpaDiscriminatorColumn)path.getObject();
            if (column.getName() == null) {
                column.setName("DTYPE");
            }
            if (column.getDiscriminatorType() == null) {
                column.setDiscriminatorType(DiscriminatorType.STRING);
            }
            if (column.getLength() == 0 && column.getDiscriminatorType() == DiscriminatorType.STRING) {
                column.setLength(31);
            }
            return false;
        }
    }

    class VersionVisitor
    extends BasicVisitor {
        VersionVisitor() {
        }

        public boolean onStartNode(ProjectPath path) {
            JpaEntity entity;
            JpaClassDescriptor descriptor;
            JpaPropertyDescriptor property;
            JpaVersion jpaBasic = (JpaVersion)path.getObject();
            if (jpaBasic.getColumn() == null) {
                JpaColumn column = new JpaColumn(AnnotationPrototypes.getColumn());
                column.setName(jpaBasic.getName());
                jpaBasic.setColumn(column);
            }
            if (jpaBasic.getTemporal() == null && java.util.Date.class.equals((property = (descriptor = (entity = path.firstInstanceOf(JpaEntity.class)).getClassDescriptor()).getProperty(jpaBasic.getName())).getType())) {
                jpaBasic.setTemporal(TemporalType.TIMESTAMP);
            }
            return true;
        }
    }

    class BasicVisitor
    extends BaseTreeVisitor {
        BasicVisitor() {
            this.addChildVisitor(JpaColumn.class, new ColumnVisitor());
        }

        public boolean onStartNode(ProjectPath path) {
            JpaBasic jpaBasic = (JpaBasic)path.getObject();
            if (jpaBasic.getColumn() == null) {
                JpaColumn column = new JpaColumn(AnnotationPrototypes.getColumn());
                column.setName(jpaBasic.getName());
                column.setNullable(jpaBasic.isOptional());
                jpaBasic.setColumn(column);
            }
            JpaAbstractEntity entity = path.firstInstanceOf(JpaAbstractEntity.class);
            if (jpaBasic.getTemporal() == null && jpaBasic.getEnumerated() == null) {
                JpaClassDescriptor descriptor = entity.getClassDescriptor();
                JpaPropertyDescriptor property = descriptor.getProperty(jpaBasic.getName());
                if (property == null) {
                    throw new IllegalStateException("No class property found for name: " + jpaBasic.getName());
                }
                if (Date.class.isAssignableFrom(property.getType())) {
                    jpaBasic.setTemporal(TemporalType.DATE);
                } else if (Time.class.isAssignableFrom(property.getType())) {
                    jpaBasic.setTemporal(TemporalType.TIME);
                } else if (Timestamp.class.isAssignableFrom(property.getType())) {
                    jpaBasic.setTemporal(TemporalType.TIMESTAMP);
                } else if (java.util.Date.class.isAssignableFrom(property.getType())) {
                    jpaBasic.setTemporal(TemporalType.TIMESTAMP);
                } else if (property.getType().isEnum()) {
                    jpaBasic.setEnumerated(EnumType.ORDINAL);
                }
            }
            return true;
        }
    }

    class EmbeddableBasicVisitor
    extends BaseTreeVisitor {
        EmbeddableBasicVisitor() {
            this.addChildVisitor(JpaColumn.class, new ColumnVisitor());
        }

        public boolean onStartNode(ProjectPath path) {
            JpaBasic jpaBasic = (JpaBasic)path.getObject();
            if (jpaBasic.getColumn() == null) {
                JpaColumn column = new JpaColumn(AnnotationPrototypes.getColumn());
                column.setName(jpaBasic.getName());
                column.setNullable(jpaBasic.isOptional());
                jpaBasic.setColumn(column);
            }
            return true;
        }
    }

    abstract class AbstractEntityVisitor
    extends BaseTreeVisitor {
        AbstractEntityVisitor() {
            BaseTreeVisitor attributeVisitor = new BaseTreeVisitor();
            attributeVisitor.addChildVisitor(JpaId.class, new IdVisitor());
            attributeVisitor.addChildVisitor(JpaBasic.class, new BasicVisitor());
            attributeVisitor.addChildVisitor(JpaVersion.class, new VersionVisitor());
            attributeVisitor.addChildVisitor(JpaManyToOne.class, new ManyToOneVisitor());
            attributeVisitor.addChildVisitor(JpaOneToOne.class, new OneToOneVisitor());
            attributeVisitor.addChildVisitor(JpaOneToMany.class, new RelationshipVisitor());
            attributeVisitor.addChildVisitor(JpaManyToMany.class, new RelationshipVisitor());
            this.addChildVisitor(JpaAttributes.class, attributeVisitor);
            this.addChildVisitor(JpaId.class, new IdVisitor());
        }

        public boolean onStartNode(ProjectPath path) {
            JpaAbstractEntity abstractEntity = (JpaAbstractEntity)path.getObject();
            if (abstractEntity.getClassName() == null) {
                return false;
            }
            if (abstractEntity.getAttributes() == null) {
                abstractEntity.setAttributes(new JpaAttributes());
            }
            JpaClassDescriptor descriptor = abstractEntity.getClassDescriptor();
            AccessType access = abstractEntity.getAccess();
            if (access == null) {
                access = ((JpaEntityMap)path.getRoot()).getAccess();
                abstractEntity.setAccess(access);
            }
            if (access == AccessType.PROPERTY) {
                for (JpaPropertyDescriptor candidate : descriptor.getPropertyDescriptors()) {
                    this.processProperty(abstractEntity, descriptor, candidate);
                }
            } else {
                for (JpaPropertyDescriptor candidate : descriptor.getFieldDescriptors()) {
                    this.processProperty(abstractEntity, descriptor, candidate);
                }
            }
            return true;
        }

        void processProperty(JpaAbstractEntity entity, JpaClassDescriptor descriptor, JpaPropertyDescriptor property) {
            JpaAttributes attributes = entity.getAttributes();
            if (attributes.getAttribute(property.getName()) != null) {
                return;
            }
            if (property.isDefaultNonRelationalType()) {
                JpaBasic attribute = new JpaBasic();
                attribute.setPropertyDescriptor(property);
                attribute.setName(property.getName());
                attributes.getBasicAttributes().add(attribute);
            } else {
                String path = descriptor.getManagedClass().getName() + "." + property.getName();
                EntityMapDefaultsProcessor.this.context.recordConflict(new SimpleValidationFailure(property.getMember(), "Undefined property persistence status: " + path));
            }
        }
    }
}

