/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.TableGenerator;
import org.apache.cayenne.jpa.map.JpaUniqueConstraint;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaTableGenerator
implements XMLSerializable {
    protected String name;
    protected String table;
    protected String catalog;
    protected String schema;
    protected String pkColumnName;
    protected String valueColumnName;
    protected String pkColumnValue;
    protected int initialValue = 0;
    protected int allocationSize = 50;
    protected Collection<JpaUniqueConstraint> uniqueConstraints;

    public JpaTableGenerator() {
    }

    public JpaTableGenerator(TableGenerator annotation) {
        this.name = annotation.name();
        this.table = annotation.table();
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.pkColumnName = annotation.pkColumnName();
        this.valueColumnName = annotation.valueColumnName();
        this.pkColumnValue = annotation.pkColumnValue();
        this.initialValue = annotation.initialValue();
        this.allocationSize = annotation.allocationSize();
        this.getUniqueConstraints();
        for (int i = 0; i < annotation.uniqueConstraints().length; ++i) {
            this.uniqueConstraints.add(new JpaUniqueConstraint(annotation.uniqueConstraints()[i]));
        }
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
    }

    public int getAllocationSize() {
        return this.allocationSize;
    }

    public void setAllocationSize(int allocationSize) {
        this.allocationSize = allocationSize;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPkColumnName() {
        return this.pkColumnName;
    }

    public void setPkColumnName(String pkColumnName) {
        this.pkColumnName = pkColumnName;
    }

    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    public void setPkColumnValue(String pkColumnValue) {
        this.pkColumnValue = pkColumnValue;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    public Collection<JpaUniqueConstraint> getUniqueConstraints() {
        if (this.uniqueConstraints == null) {
            this.uniqueConstraints = new ArrayList<JpaUniqueConstraint>(2);
        }
        return this.uniqueConstraints;
    }
}

