/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropColumnToDb
extends AbstractToDbToken {
    private DbEntity entity;
    private DbAttribute column;

    public DropColumnToDb(DbEntity entity, DbAttribute column) {
        this.entity = entity;
        this.column = column;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(this.entity.getFullyQualifiedName());
        sqlBuffer.append(" DROP COLUMN ");
        sqlBuffer.append(this.column.getName());
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public String getTokenName() {
        return "Drop Column";
    }

    @Override
    public String getTokenValue() {
        return this.entity.getName() + "." + this.column.getName();
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createAddColumnToModel(this.entity, this.column);
    }
}

