/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.ProcedureQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcedureQuery
extends AbstractQuery
implements ParameterizedQuery,
XMLSerializable {
    protected String resultEntityName;
    protected Class<?> resultClass;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    ProcedureQueryMetadata metaData = new ProcedureQueryMetadata();
    protected List<ColumnDescriptor[]> resultDescriptors;

    public ProcedureQuery() {
        this.metaData.setFetchingDataRows(true);
    }

    public ProcedureQuery(Procedure procedure) {
        this.metaData.setFetchingDataRows(true);
        this.setRoot(procedure);
    }

    public ProcedureQuery(String procedureName) {
        this.metaData.setFetchingDataRows(true);
        this.setRoot(procedureName);
    }

    public ProcedureQuery(Procedure procedure, Class<?> resultType) {
        this.setRoot(procedure);
        this.resultClass = resultType;
    }

    public ProcedureQuery(String procedureName, Class<?> resultType) {
        this.setRoot(procedureName);
        this.resultClass = resultType;
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.metaData.resolve(this.root, this.resultClass != null ? this.resultClass : this.resultEntityName, resolver, this);
        return this.metaData;
    }

    public List<ColumnDescriptor[]> getResultDescriptors() {
        return this.resultDescriptors != null ? this.resultDescriptors : Collections.EMPTY_LIST;
    }

    public synchronized void addResultDescriptor(ColumnDescriptor[] descriptor) {
        if (this.resultDescriptors == null) {
            this.resultDescriptors = new ArrayList<ColumnDescriptor[]>(2);
        }
        this.resultDescriptors.add(descriptor);
    }

    public void removeResultDescriptor(ColumnDescriptor[] descriptor) {
        if (this.resultDescriptors != null) {
            this.resultDescriptors.remove(descriptor);
        }
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.procedureAction(this);
    }

    public void initWithProperties(Map<String, ?> properties) {
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        this.metaData.initWithProperties(properties);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" factory=\"");
        encoder.print("org.apache.cayenne.map.ProcedureQueryBuilder");
        encoder.print("\" root=\"");
        encoder.print("procedure");
        String rootString = null;
        if (this.root instanceof String) {
            rootString = this.root.toString();
        } else if (this.root instanceof Procedure) {
            rootString = ((Procedure)this.root).getName();
        }
        if (rootString != null) {
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        if (this.resultEntityName != null) {
            encoder.print("\" result-entity=\"");
            encoder.print(this.resultEntityName);
        }
        encoder.println("\">");
        encoder.indent(1);
        this.metaData.encodeAsXML(encoder);
        encoder.indent(-1);
        encoder.println("</query>");
    }

    @Override
    public Query createQuery(Map<String, ?> parameters) {
        ProcedureQuery query = new ProcedureQuery();
        if (this.root != null) {
            query.setRoot(this.root);
        }
        query.setResultEntityName(this.resultEntityName);
        query.metaData.copyFromInfo(this.metaData);
        query.setParameters(parameters);
        return query;
    }

    public String getCachePolicy() {
        return this.metaData.getCachePolicy();
    }

    public void setCachePolicy(String policy) {
        this.metaData.setCachePolicy(policy);
    }

    public String[] getCacheGroups() {
        return this.metaData.getCacheGroups();
    }

    public void setCacheGroups(String[] cachGroups) {
        this.metaData.setCacheGroups(cachGroups);
    }

    public int getFetchLimit() {
        return this.metaData.getFetchLimit();
    }

    public void setFetchLimit(int fetchLimit) {
        this.metaData.setFetchLimit(fetchLimit);
    }

    public int getPageSize() {
        return this.metaData.getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.metaData.setPageSize(pageSize);
    }

    public void setFetchingDataRows(boolean flag) {
        this.metaData.setFetchingDataRows(flag);
    }

    public boolean isFetchingDataRows() {
        return this.metaData.isFetchingDataRows();
    }

    public boolean isRefreshingObjects() {
        return this.metaData.isRefreshingObjects();
    }

    public void setRefreshingObjects(boolean flag) {
        this.metaData.setRefreshingObjects(flag);
    }

    public boolean isResolvingInherited() {
        return this.metaData.isResolvingInherited();
    }

    public void setResolvingInherited(boolean b) {
        this.metaData.setResolvingInherited(b);
    }

    public synchronized void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public synchronized void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public Map<String, ?> getParameters() {
        return this.parameters;
    }

    public synchronized void setParameters(Map<String, ?> parameters) {
        this.parameters.clear();
        if (parameters != null) {
            this.parameters.putAll(parameters);
        }
    }

    public synchronized void clearParameters() {
        this.parameters.clear();
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.metaData.getPrefetchTree();
    }

    public PrefetchTreeNode addPrefetch(String prefetchPath) {
        return this.metaData.addPrefetch(prefetchPath, 1);
    }

    public void removePrefetch(String prefetch) {
        this.metaData.removePrefetch(prefetch);
    }

    public void addPrefetches(Collection<String> prefetches) {
        this.metaData.addPrefetches(prefetches, 1);
    }

    public void clearPrefetches() {
        this.metaData.clearPrefetches();
    }

    public String getResultEntityName() {
        return this.resultEntityName;
    }

    public void setResultEntityName(String resultEntityName) {
        this.resultEntityName = resultEntityName;
    }
}

