/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class NameConverter {
    private static final Map<String, String> SPECIAL_CHAR_TO_JAVA_MAPPING = new HashMap<String, String>();

    public static String javaToUnderscored(String name) {
        if (name == null) {
            return null;
        }
        name = NameConverter.specialCharsToJava(name);
        char[] charArray = name.toCharArray();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < charArray.length; ++i) {
            char prevChar;
            if (Character.isUpperCase(charArray[i]) && i != 0 && Character.isLowerCase(prevChar = charArray[i - 1])) {
                buffer.append("_");
            }
            buffer.append(Character.toUpperCase(charArray[i]));
        }
        return buffer.toString();
    }

    public static String underscoredToJava(String name, boolean capitalize) {
        StringTokenizer st = new StringTokenizer(name, "_");
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int len = (token = NameConverter.specialCharsToJava(token)).length();
            if (len == 0) continue;
            boolean hasLowerCase = false;
            boolean hasUpperCase = false;
            for (int i = 0; !(i >= len || hasUpperCase && hasLowerCase); ++i) {
                if (Character.isUpperCase(token.charAt(i))) {
                    hasUpperCase = true;
                    continue;
                }
                if (!Character.isLowerCase(token.charAt(i))) continue;
                hasLowerCase = true;
            }
            if (hasUpperCase && !hasLowerCase) {
                token = token.toLowerCase();
            }
            if (first) {
                first = false;
                if (capitalize) {
                    buf.append(Character.toUpperCase(token.charAt(0)));
                } else {
                    buf.append(Character.toLowerCase(token.charAt(0)));
                }
            } else {
                buf.append(Character.toUpperCase(token.charAt(0)));
            }
            if (len <= 1) continue;
            buf.append(token.substring(1, len));
        }
        return buf.toString();
    }

    static String specialCharsToJava(String string) {
        int len = string.length();
        if (len == 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                buffer.append(c);
                continue;
            }
            String word = SPECIAL_CHAR_TO_JAVA_MAPPING.get(String.valueOf(c));
            buffer.append((Object)(word != null ? word : "_"));
        }
        return buffer.toString();
    }

    static {
        SPECIAL_CHAR_TO_JAVA_MAPPING.put("#", "pound");
    }
}

