/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebApplicationResourceLocator
extends ResourceLocator {
    private static Log logObj = LogFactory.getLog(WebApplicationResourceLocator.class);
    protected ServletContext context;
    protected List additionalContextPaths = new ArrayList();

    public WebApplicationResourceLocator() {
        this.addFilesystemPath("/WEB-INF/");
    }

    public WebApplicationResourceLocator(ServletContext context) {
        this();
        this.setServletContext(context);
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public URL findResource(String location) {
        if (!this.additionalContextPaths.isEmpty() && this.getServletContext() != null) {
            String suffix;
            String string = suffix = location != null ? location : "";
            if (suffix.startsWith("/")) {
                suffix = suffix.substring(1);
            }
            for (String prefix : this.additionalContextPaths) {
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                String fullName = prefix + suffix;
                logObj.debug((Object)("searching for: " + fullName));
                try {
                    URL url = this.getServletContext().getResource(fullName);
                    if (url == null) continue;
                    return url;
                }
                catch (MalformedURLException ex) {
                    logObj.debug((Object)"Malformed URL, ignoring.", (Throwable)ex);
                }
            }
        }
        return super.findResource(location);
    }

    public void addFilesystemPath(String path) {
        if (path != null) {
            if (path.startsWith("/WEB-INF/")) {
                this.additionalContextPaths.add(path);
            } else {
                super.addFilesystemPath(path);
            }
        } else {
            throw new IllegalArgumentException("Path must not be null.");
        }
    }
}

