/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.map.DbEntity;

final class TransactionResultIteratorDecorator
implements ResultIterator {
    private ResultIterator result;
    private Transaction tx;

    public TransactionResultIteratorDecorator(ResultIterator result, Transaction tx) {
        this.result = result;
        this.tx = tx;
    }

    public void close() throws CayenneException {
        try {
            this.result.close();
            this.tx.commit();
        }
        catch (Exception e) {
            try {
                this.tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CayenneException(e);
        }
        finally {
            if (Transaction.getThreadTransaction() == this.tx) {
                Transaction.bindThreadTransaction(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List dataRows(boolean close) throws CayenneException {
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            while (this.hasNextRow()) {
                list.add(this.nextDataRow());
            }
        }
        finally {
            if (close) {
                this.close();
            }
        }
        return list;
    }

    public int getDataRowWidth() {
        return this.result.getDataRowWidth();
    }

    public boolean hasNextRow() throws CayenneException {
        return this.result.hasNextRow();
    }

    public Map nextDataRow() throws CayenneException {
        return this.result.nextDataRow();
    }

    public Map nextObjectId(DbEntity entity) throws CayenneException {
        return this.result.nextObjectId(entity);
    }

    public Object nextId(DbEntity entity) throws CayenneException {
        return this.result.nextId(entity);
    }

    public void skipDataRow() throws CayenneException {
        this.result.skipDataRow();
    }
}

