/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

public abstract class BaseSQLAction
implements SQLAction {
    protected DbAdapter adapter;
    protected EntityResolver entityResolver;

    public BaseSQLAction(DbAdapter adapter, EntityResolver entityResolver) {
        this.adapter = adapter;
        this.entityResolver = entityResolver;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    protected void readResultSet(ResultSet resultSet, RowDescriptor descriptor, Query query, OperationObserver delegate) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        JDBCResultIterator resultReader = new JDBCResultIterator(null, null, resultSet, descriptor, query.getMetaData(this.getEntityResolver()).getFetchLimit());
        if (!delegate.isIteratedResult()) {
            List<DataRow> resultRows = resultReader.dataRows(false);
            QueryLogger.logSelectCount(resultRows.size(), System.currentTimeMillis() - t1);
            delegate.nextDataRows(query, resultRows);
        } else {
            try {
                resultReader.setClosingConnection(true);
                delegate.nextDataRows(query, resultReader);
            }
            catch (Exception ex) {
                try {
                    resultReader.close();
                }
                catch (CayenneException cex) {
                    // empty catch block
                }
                throw ex;
            }
        }
    }
}

