/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.access.trans.JoinStack;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JoinTreeNode {
    private String targetTableAlias;
    private String sourceTableAlias;
    private DbRelationship relationship;
    private String alias;
    private JoinType joinType;
    private Collection<JoinTreeNode> children;
    private JoinStack joinProcessor;

    JoinTreeNode(JoinStack joinProcessor) {
        this.joinProcessor = joinProcessor;
    }

    JoinTreeNode(JoinStack joinProcessor, DbRelationship relationship, JoinType joinType, String alias) {
        this(joinProcessor);
        this.relationship = relationship;
        this.alias = alias;
        this.joinType = joinType;
    }

    int size() {
        int i = 1;
        if (this.children != null) {
            for (JoinTreeNode child : this.children) {
                i += child.size();
            }
        }
        return i;
    }

    Collection<JoinTreeNode> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    JoinTreeNode findOrCreateChild(DbRelationship relationship, JoinType joinType, String alias) {
        if (this.children == null) {
            this.children = new ArrayList<JoinTreeNode>(4);
        } else {
            for (JoinTreeNode child : this.children) {
                if (!child.equals(relationship, joinType, alias)) continue;
                return child;
            }
        }
        JoinTreeNode child = new JoinTreeNode(this.joinProcessor, relationship, joinType, alias);
        child.setSourceTableAlias(this.targetTableAlias);
        child.setTargetTableAlias(this.joinProcessor.newAlias());
        this.children.add(child);
        return child;
    }

    private boolean equals(DbRelationship relationship, JoinType joinType, String alias) {
        return this.relationship == relationship && this.joinType == joinType && Util.nullSafeEquals(this.alias, alias);
    }

    String getTargetTableAlias() {
        return this.targetTableAlias;
    }

    void setTargetTableAlias(String targetTableAlias) {
        this.targetTableAlias = targetTableAlias;
    }

    String getSourceTableAlias() {
        return this.sourceTableAlias;
    }

    void setSourceTableAlias(String sourceTableAlias) {
        this.sourceTableAlias = sourceTableAlias;
    }

    DbRelationship getRelationship() {
        return this.relationship;
    }

    String getAlias() {
        return this.alias;
    }

    JoinType getJoinType() {
        return this.joinType;
    }
}

