/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.jpa.Provider;
import org.apache.cayenne.jpa.ResourceLocalEntityManager;
import org.apache.cayenne.jpa.TypeCheckingEntityManager;

public class ResourceLocalEntityManagerFactory
implements EntityManagerFactory {
    protected DataDomain domain;
    protected boolean open;
    protected PersistenceUnitInfo unitInfo;
    protected Provider provider;

    ResourceLocalEntityManagerFactory(PersistenceUnitInfo unitInfo) {
        this(null, null, unitInfo);
    }

    public ResourceLocalEntityManagerFactory(Provider provider, DataDomain domain, PersistenceUnitInfo unitInfo) {
        this.unitInfo = unitInfo;
        this.open = true;
        this.domain = domain;
        this.provider = provider;
    }

    protected PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.unitInfo;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.checkClosed();
        this.open = false;
    }

    public EntityManager createEntityManager() {
        return this.createEntityManager(Collections.EMPTY_MAP);
    }

    public EntityManager createEntityManager(Map map) {
        this.checkClosed();
        ResourceLocalEntityManager em = new ResourceLocalEntityManager(this.createObjectContext(), this);
        return new TypeCheckingEntityManager(em);
    }

    protected ObjectContext createObjectContext() {
        return this.domain.createDataContext();
    }

    void checkClosed() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("An attempt to access closed EntityManagerFactory.");
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    PersistenceUnitInfo getUnitInfo() {
        return this.unitInfo;
    }
}

