/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryLoader;
import org.apache.cayenne.map.SelectQueryBuilder;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MapLoader
extends DefaultHandler {
    static final String _1_2_PACKAGE_PREFIX = "org.objectstyle.cayenne.";
    static final String _2_0_PACKAGE_PREFIX = "org.apache.cayenne.";
    public static final String DATA_MAP_TAG = "data-map";
    public static final String PROPERTY_TAG = "property";
    public static final String EMBEDDABLE_TAG = "embeddable";
    public static final String EMBEDDABLE_ATTRIBUTE_TAG = "embeddable-attribute";
    public static final String EMBEDDED_ATTRIBUTE_TAG = "embedded-attribute";
    public static final String EMBEDDABLE_ATTRIBUTE_OVERRIDE_TAG = "embeddable-attribute-override";
    public static final String DB_ENTITY_TAG = "db-entity";
    public static final String OBJ_ENTITY_TAG = "obj-entity";
    public static final String DB_ATTRIBUTE_TAG = "db-attribute";
    public static final String OBJ_ATTRIBUTE_TAG = "obj-attribute";
    public static final String OBJ_RELATIONSHIP_TAG = "obj-relationship";
    public static final String DB_RELATIONSHIP_TAG = "db-relationship";
    public static final String DB_RELATIONSHIP_REF_TAG = "db-relationship-ref";
    public static final String DB_ATTRIBUTE_PAIR_TAG = "db-attribute-pair";
    public static final String PROCEDURE_TAG = "procedure";
    public static final String PROCEDURE_PARAMETER_TAG = "procedure-parameter";
    public static final String ENTITY_LISTENER_TAG = "entity-listener";
    public static final String PRE_PERSIST_TAG = "pre-persist";
    public static final String POST_PERSIST_TAG = "post-persist";
    public static final String PRE_UPDATE_TAG = "pre-update";
    public static final String POST_UPDATE_TAG = "post-update";
    public static final String PRE_REMOVE_TAG = "pre-remove";
    public static final String POST_REMOVE_TAG = "post-remove";
    public static final String POST_LOAD_TAG = "post-load";
    public static final String QUERY_TAG = "query";
    public static final String QUERY_SQL_TAG = "sql";
    public static final String QUERY_QUALIFIER_TAG = "qualifier";
    public static final String QUERY_ORDERING_TAG = "ordering";
    public static final String QUERY_PREFETCH_TAG = "prefetch";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String DB_KEY_GENERATOR_TAG = "db-key-generator";
    public static final String DB_GENERATOR_TYPE_TAG = "db-generator-type";
    public static final String DB_GENERATOR_NAME_TAG = "db-generator-name";
    public static final String DB_KEY_CACHE_SIZE_TAG = "db-key-cache-size";
    public static final String OBJ_ENTITY_ROOT = "obj-entity";
    public static final String DB_ENTITY_ROOT = "db-entity";
    public static final String PROCEDURE_ROOT = "procedure";
    public static final String DATA_MAP_ROOT = "data-map";
    public static final String JAVA_CLASS_ROOT = "java-class";
    private DataMap dataMap;
    private DbEntity dbEntity;
    private ObjEntity objEntity;
    private EntityListener entityListener;
    private Embeddable embeddable;
    private EmbeddedAttribute embeddedAttribute;
    private DbRelationship dbRelationship;
    private ObjRelationship objRelationship;
    private DbAttribute attrib;
    private Procedure procedure;
    private QueryLoader queryBuilder;
    private String sqlKey;
    private String descending;
    private String ignoreCase;
    private Map<String, StartClosure> startTagOpMap = new HashMap<String, StartClosure>(40);
    private Map<String, EndClosure> endTagOpMap = new HashMap<String, EndClosure>(40);
    private String currentTag;
    private StringBuilder charactersBuffer;
    private Map<String, Object> mapProperties;

    public MapLoader() {
        this.startTagOpMap.put("db-entity", new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartDbEntity(attributes);
            }
        });
        this.startTagOpMap.put(DB_ATTRIBUTE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartDbAttribute(attributes);
            }
        });
        this.startTagOpMap.put("obj-entity", new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartObjEntity(attributes);
            }
        });
        this.startTagOpMap.put(OBJ_ATTRIBUTE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartObjAttribute(attributes);
            }
        });
        this.startTagOpMap.put(EMBEDDABLE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartEmbeddable(attributes);
            }
        });
        this.startTagOpMap.put(EMBEDDABLE_ATTRIBUTE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartEmbeddableAttribute(attributes);
            }
        });
        this.startTagOpMap.put(EMBEDDABLE_ATTRIBUTE_OVERRIDE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartEmbeddableAttributeOverride(attributes);
            }
        });
        this.startTagOpMap.put(EMBEDDED_ATTRIBUTE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartEmbeddedAttribute(attributes);
            }
        });
        this.startTagOpMap.put(DB_RELATIONSHIP_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartDbRelationship(attributes);
            }
        });
        this.startTagOpMap.put(DB_ATTRIBUTE_PAIR_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartDbAttributePair(attributes);
            }
        });
        this.startTagOpMap.put(OBJ_RELATIONSHIP_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartObjRelationship(attributes);
            }
        });
        this.startTagOpMap.put(DB_RELATIONSHIP_REF_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartDbRelationshipRef(attributes);
            }
        });
        this.startTagOpMap.put(PROCEDURE_PARAMETER_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartProcedureParameter(attributes);
            }
        });
        this.startTagOpMap.put("procedure", new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartProcedure(attributes);
            }
        });
        this.startTagOpMap.put(QUERY_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartQuery(attributes);
            }
        });
        this.startTagOpMap.put(QUERY_SQL_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.charactersBuffer = new StringBuilder();
                MapLoader.this.processStartQuerySQL(attributes);
            }
        });
        this.startTagOpMap.put(QUERY_ORDERING_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.charactersBuffer = new StringBuilder();
                MapLoader.this.processStartQueryOrdering(attributes);
            }
        });
        this.startTagOpMap.put(DB_KEY_GENERATOR_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartDbKeyGenerator(attributes);
            }
        });
        this.startTagOpMap.put(PROPERTY_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                if (MapLoader.this.queryBuilder != null) {
                    MapLoader.this.processStartQueryProperty(attributes);
                } else {
                    MapLoader.this.processStartDataMapProperty(attributes);
                }
            }
        });
        this.startTagOpMap.put(ENTITY_LISTENER_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartEntitylistener(attributes);
            }
        });
        this.startTagOpMap.put(PRE_PERSIST_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartPrePersist(attributes);
            }
        });
        this.startTagOpMap.put(POST_PERSIST_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartPostPersist(attributes);
            }
        });
        this.startTagOpMap.put(PRE_UPDATE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartPreUpdate(attributes);
            }
        });
        this.startTagOpMap.put(POST_UPDATE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartPostUpdate(attributes);
            }
        });
        this.startTagOpMap.put(PRE_REMOVE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartPreRemove(attributes);
            }
        });
        this.startTagOpMap.put(POST_REMOVE_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartPostRemove(attributes);
            }
        });
        this.startTagOpMap.put(POST_LOAD_TAG, new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.processStartPostLoad(attributes);
            }
        });
        StartClosure resetBuffer = new StartClosure(){

            void execute(Attributes attributes) throws SAXException {
                MapLoader.this.charactersBuffer = new StringBuilder();
            }
        };
        this.startTagOpMap.put(QUERY_PREFETCH_TAG, resetBuffer);
        this.startTagOpMap.put(QUERY_QUALIFIER_TAG, resetBuffer);
        this.startTagOpMap.put(DB_GENERATOR_TYPE_TAG, resetBuffer);
        this.startTagOpMap.put(DB_GENERATOR_NAME_TAG, resetBuffer);
        this.startTagOpMap.put(DB_KEY_CACHE_SIZE_TAG, resetBuffer);
        this.endTagOpMap.put("data-map", new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndDataMap();
            }
        });
        this.endTagOpMap.put("db-entity", new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndDbEntity();
            }
        });
        this.endTagOpMap.put("obj-entity", new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndObjEntity();
            }
        });
        this.endTagOpMap.put(EMBEDDABLE_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndEmbeddable();
            }
        });
        this.endTagOpMap.put(EMBEDDABLE_ATTRIBUTE_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndEmbeddedAttribute();
            }
        });
        this.endTagOpMap.put(DB_ATTRIBUTE_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndDbAttribute();
            }
        });
        this.endTagOpMap.put(DB_RELATIONSHIP_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndDbRelationship();
            }
        });
        this.endTagOpMap.put(OBJ_RELATIONSHIP_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndObjRelationship();
            }
        });
        this.endTagOpMap.put(DB_GENERATOR_TYPE_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndDbGeneratorType();
            }
        });
        this.endTagOpMap.put(DB_GENERATOR_NAME_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndDbGeneratorName();
            }
        });
        this.endTagOpMap.put(DB_KEY_CACHE_SIZE_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndDbKeyCacheSize();
            }
        });
        this.endTagOpMap.put(PROCEDURE_PARAMETER_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndProcedureParameter();
            }
        });
        this.endTagOpMap.put("procedure", new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndProcedure();
            }
        });
        this.endTagOpMap.put(QUERY_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndQuery();
            }
        });
        this.endTagOpMap.put(QUERY_SQL_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndQuerySQL();
            }
        });
        this.endTagOpMap.put(QUERY_QUALIFIER_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndQualifier();
            }
        });
        this.endTagOpMap.put(QUERY_ORDERING_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndQueryOrdering();
            }
        });
        this.endTagOpMap.put(QUERY_PREFETCH_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndQueryPrefetch();
            }
        });
        this.endTagOpMap.put(ENTITY_LISTENER_TAG, new EndClosure(){

            void execute() throws SAXException {
                MapLoader.this.processEndEntitylistener();
            }
        });
    }

    private void processStartEntitylistener(Attributes attributes) {
        this.entityListener = new EntityListener(attributes.getValue("", "class"));
        if (this.objEntity != null) {
            this.objEntity.addEntityListener(this.entityListener);
        } else if (this.dataMap != null) {
            this.dataMap.addDefaultEntityListener(this.entityListener);
        }
    }

    private void processEndEntitylistener() {
        this.entityListener = null;
    }

    private void processStartPrePersist(Attributes attributes) {
        String methodName = attributes.getValue("", "method-name");
        if (this.entityListener != null) {
            this.entityListener.getCallbackMap().getPrePersist().addCallbackMethod(methodName);
        } else if (this.objEntity != null) {
            this.objEntity.getCallbackMap().getPrePersist().addCallbackMethod(methodName);
        }
    }

    private void processStartPostPersist(Attributes attributes) {
        String methodName = attributes.getValue("", "method-name");
        if (this.entityListener != null) {
            this.entityListener.getCallbackMap().getPostPersist().addCallbackMethod(methodName);
        } else if (this.objEntity != null) {
            this.objEntity.getCallbackMap().getPostPersist().addCallbackMethod(methodName);
        }
    }

    private void processStartPreUpdate(Attributes attributes) {
        String methodName = attributes.getValue("", "method-name");
        if (this.entityListener != null) {
            this.entityListener.getCallbackMap().getPreUpdate().addCallbackMethod(methodName);
        } else if (this.objEntity != null) {
            this.objEntity.getCallbackMap().getPreUpdate().addCallbackMethod(methodName);
        }
    }

    private void processStartPostUpdate(Attributes attributes) {
        String methodName = attributes.getValue("", "method-name");
        if (this.entityListener != null) {
            this.entityListener.getCallbackMap().getPostUpdate().addCallbackMethod(methodName);
        } else if (this.objEntity != null) {
            this.objEntity.getCallbackMap().getPostUpdate().addCallbackMethod(methodName);
        }
    }

    private void processStartPreRemove(Attributes attributes) {
        String methodName = attributes.getValue("", "method-name");
        if (this.entityListener != null) {
            this.entityListener.getCallbackMap().getPreRemove().addCallbackMethod(methodName);
        } else if (this.objEntity != null) {
            this.objEntity.getCallbackMap().getPreRemove().addCallbackMethod(methodName);
        }
    }

    private void processStartPostRemove(Attributes attributes) {
        String methodName = attributes.getValue("", "method-name");
        if (this.entityListener != null) {
            this.entityListener.getCallbackMap().getPostRemove().addCallbackMethod(methodName);
        } else if (this.objEntity != null) {
            this.objEntity.getCallbackMap().getPostRemove().addCallbackMethod(methodName);
        }
    }

    private void processStartPostLoad(Attributes attributes) {
        String methodName = attributes.getValue("", "method-name");
        if (this.entityListener != null) {
            this.entityListener.getCallbackMap().getPostLoad().addCallbackMethod(methodName);
        } else if (this.objEntity != null) {
            this.objEntity.getCallbackMap().getPostLoad().addCallbackMethod(methodName);
        }
    }

    public synchronized DataMap loadDataMap(InputSource src) throws CayenneRuntimeException {
        if (src == null) {
            throw new NullPointerException("Null InputSource.");
        }
        try {
            String mapName = this.mapNameFromLocation(src.getSystemId());
            this.dataMap = new DataMap(mapName);
            XMLReader parser = Util.createXmlReader();
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.parse(src);
        }
        catch (SAXException e) {
            this.dataMap = null;
            throw new CayenneRuntimeException("Wrong DataMap format, last processed tag: <" + this.currentTag, Util.unwindException(e));
        }
        catch (Exception e) {
            this.dataMap = null;
            throw new CayenneRuntimeException("Error loading DataMap, last processed tag: <" + this.currentTag, Util.unwindException(e));
        }
        return this.dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataMap loadDataMap(String uri) throws CayenneRuntimeException {
        ResourceLocator locator = this.configLocator();
        InputStream in = locator.findResourceStream(uri);
        if (in == null) {
            throw new CayenneRuntimeException("Can't find data map " + uri);
        }
        try {
            InputSource inSrc = new InputSource(in);
            inSrc.setSystemId(uri);
            DataMap dataMap = this.loadDataMap(inSrc);
            return dataMap;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioex) {}
        }
    }

    protected String mapNameFromLocation(String location) {
        if (location == null) {
            return "Untitled";
        }
        int lastSlash = location.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = location.lastIndexOf(92);
        }
        if (lastSlash >= 0 && lastSlash + 1 < location.length()) {
            location = location.substring(lastSlash + 1);
        }
        if (location.endsWith(".map.xml")) {
            location = location.substring(0, location.length() - ".map.xml".length());
        }
        return location;
    }

    protected ResourceLocator configLocator() {
        ResourceLocator locator = new ResourceLocator();
        locator.setSkipAbsolutePath(true);
        locator.setSkipClasspath(false);
        locator.setSkipCurrentDirectory(false);
        locator.setSkipHomeDirectory(false);
        return locator;
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        this.rememberCurrentTag(localName);
        StartClosure op = this.startTagOpMap.get(localName);
        if (op != null) {
            op.execute(attributes);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        EndClosure op = this.endTagOpMap.get(localName);
        if (op != null) {
            op.execute();
        }
        this.resetCurrentTag();
        this.charactersBuffer = null;
    }

    private void processStartEmbeddable(Attributes atts) {
        this.embeddable = new Embeddable(atts.getValue("", "className"));
        this.dataMap.addEmbeddable(this.embeddable);
    }

    private void processStartEmbeddableAttribute(Attributes atts) {
        String name = atts.getValue("", "name");
        String type = atts.getValue("", "type");
        String dbName = atts.getValue("", "db-attribute-name");
        EmbeddableAttribute ea = new EmbeddableAttribute(name);
        ea.setType(type);
        ea.setDbAttributeName(dbName);
        this.embeddable.addAttribute(ea);
    }

    private void processStartEmbeddedAttribute(Attributes atts) {
        String name = atts.getValue("", "name");
        String type = atts.getValue("", "type");
        this.embeddedAttribute = new EmbeddedAttribute(name);
        this.embeddedAttribute.setType(type);
        this.objEntity.addAttribute(this.embeddedAttribute);
    }

    private void processStartEmbeddableAttributeOverride(Attributes atts) {
        String name = atts.getValue("", "name");
        String dbName = atts.getValue("", "db-attribute-path");
        this.embeddedAttribute.addAttributeOverride(name, dbName);
    }

    private void processStartDbEntity(Attributes atts) {
        String name = atts.getValue("", "name");
        this.dbEntity = new DbEntity(name);
        this.dbEntity.setSchema(atts.getValue("", "schema"));
        this.dbEntity.setCatalog(atts.getValue("", "catalog"));
        this.dataMap.addDbEntity(this.dbEntity);
    }

    private void processStartDbAttribute(Attributes atts) {
        String scale;
        String precision;
        String pseudoPrecision;
        String name = atts.getValue("", "name");
        String type = atts.getValue("", "type");
        this.attrib = new DbAttribute(name);
        this.attrib.setType(TypesMapping.getSqlTypeByName(type));
        this.dbEntity.addAttribute(this.attrib);
        String length = atts.getValue("", "length");
        if (length != null) {
            this.attrib.setMaxLength(Integer.parseInt(length));
        }
        if ((pseudoPrecision = atts.getValue("", "precision")) != null) {
            this.attrib.setScale(Integer.parseInt(pseudoPrecision));
        }
        if ((precision = atts.getValue("", "attributePrecision")) != null) {
            this.attrib.setAttributePrecision(Integer.parseInt(precision));
        }
        if ((scale = atts.getValue("", "scale")) != null) {
            this.attrib.setScale(Integer.parseInt(scale));
        }
        this.attrib.setPrimaryKey(TRUE.equalsIgnoreCase(atts.getValue("", "isPrimaryKey")));
        this.attrib.setMandatory(TRUE.equalsIgnoreCase(atts.getValue("", "isMandatory")));
        this.attrib.setGenerated(TRUE.equalsIgnoreCase(atts.getValue("", "isGenerated")));
    }

    private void processStartDbKeyGenerator(Attributes atts) {
        DbKeyGenerator pkGenerator = new DbKeyGenerator();
        this.dbEntity.setPrimaryKeyGenerator(pkGenerator);
    }

    private void processStartQuerySQL(Attributes atts) {
        this.sqlKey = this.convertClassNameFromV1_2(atts.getValue("", "adapter-class"));
    }

    private void processStartObjEntity(Attributes atts) {
        String superEntityName;
        this.objEntity = new ObjEntity(atts.getValue("", "name"));
        this.objEntity.setClassName(atts.getValue("", "className"));
        this.objEntity.setClientClassName(atts.getValue("", "clientClassName"));
        String readOnly = atts.getValue("", "readOnly");
        this.objEntity.setReadOnly(TRUE.equalsIgnoreCase(readOnly));
        String serverOnly = atts.getValue("", "serverOnly");
        this.objEntity.setServerOnly(TRUE.equalsIgnoreCase(serverOnly));
        String excludeSuperclassListeners = atts.getValue("", "exclude-superclass-listeners");
        this.objEntity.setExcludingSuperclassListeners(TRUE.equalsIgnoreCase(excludeSuperclassListeners));
        String excludeDefaultListeners = atts.getValue("", "exclude-default-listeners");
        this.objEntity.setExcludingDefaultListeners(TRUE.equalsIgnoreCase(excludeDefaultListeners));
        String lockType = atts.getValue("", "lock-type");
        if ("optimistic".equals(lockType)) {
            this.objEntity.setDeclaredLockType(1);
        }
        if ((superEntityName = atts.getValue("", "superEntityName")) != null) {
            this.objEntity.setSuperEntityName(superEntityName);
        } else {
            this.objEntity.setDbEntityName(atts.getValue("", "dbEntityName"));
            this.objEntity.setSuperClassName(atts.getValue("", "superClassName"));
            this.objEntity.setClientSuperClassName(atts.getValue("", "clientSuperClassName"));
        }
        this.dataMap.addObjEntity(this.objEntity);
    }

    private void processStartObjAttribute(Attributes atts) {
        String name = atts.getValue("", "name");
        String type = atts.getValue("", "type");
        String lock = atts.getValue("", "lock");
        ObjAttribute oa = new ObjAttribute(name);
        oa.setType(type);
        oa.setUsedForLocking(TRUE.equalsIgnoreCase(lock));
        this.objEntity.addAttribute(oa);
        String dbPath = atts.getValue("", "db-attribute-path");
        if (dbPath == null) {
            dbPath = atts.getValue("", "db-attribute-name");
        }
        oa.setDbAttributePath(dbPath);
    }

    private void processStartDbRelationship(Attributes atts) throws SAXException {
        String name = atts.getValue("", "name");
        if (name == null) {
            throw new SAXException("MapLoader::processStartDbRelationship(), Unable to parse name. Attributes:\n" + this.printAttributes(atts));
        }
        String sourceName = atts.getValue("", "source");
        if (sourceName == null) {
            throw new SAXException("MapLoader::processStartDbRelationship() - null source entity");
        }
        DbEntity source = this.dataMap.getDbEntity(sourceName);
        if (source == null) {
            return;
        }
        String toManyString = atts.getValue("", "toMany");
        boolean toMany = toManyString != null && toManyString.equalsIgnoreCase(TRUE);
        String toDependPkString = atts.getValue("", "toDependentPK");
        boolean toDependentPK = toDependPkString != null && toDependPkString.equalsIgnoreCase(TRUE);
        this.dbRelationship = new DbRelationship(name);
        this.dbRelationship.setSourceEntity(source);
        this.dbRelationship.setTargetEntityName(atts.getValue("", "target"));
        this.dbRelationship.setToMany(toMany);
        this.dbRelationship.setToDependentPK(toDependentPK);
        source.addRelationship(this.dbRelationship);
    }

    private void processStartDbRelationshipRef(Attributes atts) throws SAXException {
        String name = atts.getValue("", "name");
        if (name == null) {
            throw new SAXException("MapLoader::processStartDbRelationshipRef(), Null DbRelationship name for " + this.objRelationship.getName());
        }
        String path = this.objRelationship.getDbRelationshipPath();
        path = path != null ? path + "." + name : name;
        this.objRelationship.setDbRelationshipPath(path);
    }

    private void processStartDbAttributePair(Attributes atts) {
        DbJoin join = new DbJoin(this.dbRelationship);
        join.setSourceName(atts.getValue("", "source"));
        join.setTargetName(atts.getValue("", "target"));
        this.dbRelationship.addJoin(join);
    }

    private void processStartObjRelationship(Attributes atts) throws SAXException {
        String name = atts.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartObjRelationship(), Unable to parse target. Attributes:\n" + this.printAttributes(atts));
        }
        String collectionType = atts.getValue("", "collection-type");
        String mapKey = atts.getValue("", "map-key");
        String sourceName = atts.getValue("", "source");
        if (sourceName == null) {
            throw new SAXException("MapLoader::processStartObjRelationship(), Unable to parse source. Attributes:\n" + this.printAttributes(atts));
        }
        ObjEntity source = this.dataMap.getObjEntity(sourceName);
        if (source == null) {
            throw new SAXException("MapLoader::processStartObjRelationship(), Unable to find source " + sourceName);
        }
        String deleteRuleName = atts.getValue("", "deleteRule");
        int deleteRule = deleteRuleName != null ? DeleteRule.deleteRuleForName(deleteRuleName) : 0;
        this.objRelationship = new ObjRelationship(name);
        this.objRelationship.setSourceEntity(source);
        this.objRelationship.setTargetEntityName(atts.getValue("", "target"));
        this.objRelationship.setDeleteRule(deleteRule);
        this.objRelationship.setUsedForLocking(TRUE.equalsIgnoreCase(atts.getValue("", "lock")));
        this.objRelationship.setDbRelationshipPath(atts.getValue("", "db-relationship-path"));
        this.objRelationship.setCollectionType(collectionType);
        this.objRelationship.setMapKey(mapKey);
        source.addRelationship(this.objRelationship);
    }

    private void processStartProcedure(Attributes attributes) throws SAXException {
        String name = attributes.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartProcedure(), no procedure name.");
        }
        String schema = attributes.getValue("", "schema");
        String catalog = attributes.getValue("", "catalog");
        String returningValue = attributes.getValue("", "returningValue");
        this.procedure = new Procedure(name);
        this.procedure.setReturningValue(returningValue != null && returningValue.equalsIgnoreCase(TRUE));
        this.procedure.setSchema(schema);
        this.procedure.setCatalog(catalog);
        this.dataMap.addProcedure(this.procedure);
    }

    private void processStartProcedureParameter(Attributes attributes) throws SAXException {
        String direction;
        String precision;
        String length;
        String name = attributes.getValue("", "name");
        if (name == null) {
            throw new SAXException("MapLoader::processStartProcedureParameter(), no procedure parameter name.");
        }
        ProcedureParameter parameter = new ProcedureParameter(name);
        String type = attributes.getValue("", "type");
        if (type != null) {
            parameter.setType(TypesMapping.getSqlTypeByName(type));
        }
        if ((length = attributes.getValue("", "length")) != null) {
            parameter.setMaxLength(Integer.parseInt(length));
        }
        if ((precision = attributes.getValue("", "precision")) != null) {
            parameter.setPrecision(Integer.parseInt(precision));
        }
        if ("in".equals(direction = attributes.getValue("", "direction"))) {
            parameter.setDirection(1);
        } else if ("out".equals(direction)) {
            parameter.setDirection(2);
        } else if ("in_out".equals(direction)) {
            parameter.setDirection(3);
        }
        this.procedure.addCallParameter(parameter);
    }

    private void processStartQuery(Attributes attributes) throws SAXException {
        String name = attributes.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartQuery(), no query name.");
        }
        String builder = attributes.getValue("", "factory");
        builder = builder == null ? SelectQueryBuilder.class.getName() : (builder.equals("org.objectstyle.cayenne.query.SelectQueryBuilder") ? SelectQueryBuilder.class.getName() : this.convertClassNameFromV1_2(builder));
        try {
            this.queryBuilder = (QueryLoader)Class.forName(builder).newInstance();
        }
        catch (Exception ex) {
            throw new SAXException("MapLoader::processStartQuery(), invalid query builder: " + builder);
        }
        String rootType = attributes.getValue("", "root");
        String rootName = attributes.getValue("", "root-name");
        String resultEntity = attributes.getValue("", "result-entity");
        this.queryBuilder.setName(name);
        this.queryBuilder.setRoot(this.dataMap, rootType, rootName);
        if (!Util.isEmptyString(resultEntity)) {
            this.queryBuilder.setResultEntity(resultEntity);
        }
    }

    private void processStartQueryProperty(Attributes attributes) throws SAXException {
        String name = attributes.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartQueryProperty(), no property name.");
        }
        String value = attributes.getValue("", "value");
        if (null == value) {
            throw new SAXException("MapLoader::processStartQueryProperty(), no property value.");
        }
        this.queryBuilder.addProperty(name, value);
    }

    private void processStartDataMapProperty(Attributes attributes) throws SAXException {
        String name = attributes.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartDataMapProperty(), no property name.");
        }
        String value = attributes.getValue("", "value");
        if (null == value) {
            throw new SAXException("MapLoader::processStartDataMapProperty(), no property value.");
        }
        if (this.mapProperties == null) {
            this.mapProperties = new TreeMap<String, Object>();
        }
        this.mapProperties.put(name, value);
    }

    private void processEndQueryPrefetch() {
        this.queryBuilder.addPrefetch(this.charactersBuffer.toString());
    }

    private void processStartQueryOrdering(Attributes attributes) {
        this.descending = attributes.getValue("", "descending");
        this.ignoreCase = attributes.getValue("", "ignore-case");
    }

    private void processEndQuery() {
        this.dataMap.addQuery(this.queryBuilder.getQuery());
        this.queryBuilder = null;
    }

    private void processEndQuerySQL() {
        this.queryBuilder.addSql(this.charactersBuffer.toString(), this.sqlKey);
        this.sqlKey = null;
    }

    private void processEndQualifier() {
        String qualifier = this.charactersBuffer.toString();
        if (qualifier.trim().length() == 0) {
            return;
        }
        if (this.objEntity != null) {
            this.objEntity.setDeclaredQualifier(Expression.fromString(qualifier));
        } else {
            this.queryBuilder.setQualifier(qualifier);
        }
    }

    private void processEndQueryOrdering() {
        String path = this.charactersBuffer.toString();
        this.queryBuilder.addOrdering(path, this.descending, this.ignoreCase);
    }

    private void processEndDbAttribute() {
        this.attrib = null;
    }

    private void processEndDbEntity() {
        this.dbEntity = null;
    }

    private void processEndProcedure() {
        this.procedure = null;
    }

    private void processEndProcedureParameter() {
    }

    private void processEndDbGeneratorType() {
        if (this.dbEntity == null) {
            return;
        }
        DbKeyGenerator pkGenerator = this.dbEntity.getPrimaryKeyGenerator();
        if (pkGenerator == null) {
            return;
        }
        pkGenerator.setGeneratorType(this.charactersBuffer.toString());
        if (pkGenerator.getGeneratorType() == null) {
            this.dbEntity.setPrimaryKeyGenerator(null);
        }
    }

    private void processEndDbGeneratorName() {
        if (this.dbEntity == null) {
            return;
        }
        DbKeyGenerator pkGenerator = this.dbEntity.getPrimaryKeyGenerator();
        if (pkGenerator == null) {
            return;
        }
        pkGenerator.setGeneratorName(this.charactersBuffer.toString());
    }

    private void processEndDbKeyCacheSize() {
        if (this.dbEntity == null) {
            return;
        }
        DbKeyGenerator pkGenerator = this.dbEntity.getPrimaryKeyGenerator();
        if (pkGenerator == null) {
            return;
        }
        try {
            pkGenerator.setKeyCacheSize(new Integer(this.charactersBuffer.toString().trim()));
        }
        catch (Exception ex) {
            pkGenerator.setKeyCacheSize(null);
        }
    }

    private void processEndDataMap() {
        if (this.mapProperties != null) {
            this.dataMap.initWithProperties(this.mapProperties);
        }
        this.mapProperties = null;
    }

    private void processEndObjEntity() {
        this.objEntity = null;
    }

    private void processEndEmbeddable() {
        this.embeddable = null;
    }

    private void processEndEmbeddedAttribute() {
        this.embeddedAttribute = null;
    }

    private void processEndDbRelationship() {
        this.dbRelationship = null;
    }

    private void processEndObjRelationship() {
        this.objRelationship = null;
    }

    private StringBuffer printAttributes(Attributes atts) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < atts.getLength(); ++i) {
            String value = atts.getQName(i);
            String name = atts.getValue(i);
            sb.append("Name: ").append(name).append("\tValue: ").append(value).append("\n");
        }
        return sb;
    }

    public void characters(char[] text, int start, int length) throws SAXException {
        if (this.charactersBuffer != null) {
            this.charactersBuffer.append(text, start, length);
        }
    }

    private void rememberCurrentTag(String tag) {
        this.currentTag = tag;
    }

    private void resetCurrentTag() {
        this.currentTag = null;
    }

    String convertClassNameFromV1_2(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith(_1_2_PACKAGE_PREFIX)) {
            return _2_0_PACKAGE_PREFIX + name.substring(_1_2_PACKAGE_PREFIX.length());
        }
        return name;
    }

    abstract class EndClosure {
        EndClosure() {
        }

        abstract void execute() throws SAXException;
    }

    abstract class StartClosure {
        StartClosure() {
        }

        abstract void execute(Attributes var1) throws SAXException;
    }
}

