/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.ClientObjAttribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.commons.collections.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjAttribute
extends Attribute {
    protected String type;
    protected boolean usedForLocking;
    protected String dbAttributePath;

    public ObjAttribute() {
    }

    public ObjAttribute(String name) {
        super(name);
    }

    public ObjAttribute(String name, String type, ObjEntity entity) {
        this.setName(name);
        this.setType(type);
        this.setEntity(entity);
    }

    public Class<?> getJavaClass() {
        if (this.getType() == null) {
            return null;
        }
        try {
            return Util.getJavaClass(this.getType());
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Failed to load class for name '" + this.getType() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<obj-attribute name=\"" + this.getName() + '\"');
        if (this.getType() != null) {
            encoder.print(" type=\"");
            encoder.print(this.getType());
            encoder.print('\"');
        }
        if (this.isUsedForLocking()) {
            encoder.print(" lock=\"true\"");
        }
        if (this.getDbAttribute() != null) {
            encoder.print(" db-attribute-path=\"");
            encoder.print(Util.encodeXmlAttribute(this.getDbAttributePath()));
            encoder.print('\"');
        }
        encoder.println("/>");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPrimaryKey() {
        if (this.dbAttributePath == null) {
            return false;
        }
        DbAttribute dbAttribute = this.getDbAttribute();
        return dbAttribute != null && dbAttribute.isPrimaryKey();
    }

    public boolean isUsedForLocking() {
        return this.usedForLocking;
    }

    public void setUsedForLocking(boolean usedForLocking) {
        this.usedForLocking = usedForLocking;
    }

    public DbAttribute getDbAttribute() {
        Iterator<CayenneMapEntry> pathIterator = this.getDbPathIterator();
        CayenneMapEntry o = null;
        while (pathIterator.hasNext()) {
            o = pathIterator.next();
        }
        return (DbAttribute)o;
    }

    public Iterator<CayenneMapEntry> getDbPathIterator() {
        if (this.dbAttributePath == null) {
            return IteratorUtils.EMPTY_ITERATOR;
        }
        ObjEntity ent = (ObjEntity)this.getEntity();
        if (ent == null) {
            return IteratorUtils.EMPTY_ITERATOR;
        }
        DbEntity dbEnt = ent.getDbEntity();
        if (dbEnt == null) {
            return IteratorUtils.EMPTY_ITERATOR;
        }
        int lastPartStart = this.dbAttributePath.lastIndexOf(46);
        if (lastPartStart < 0) {
            DbAttribute attribute = (DbAttribute)dbEnt.getAttribute(this.dbAttributePath);
            if (attribute == null) {
                return IteratorUtils.EMPTY_ITERATOR;
            }
            return IteratorUtils.singletonIterator((Object)attribute);
        }
        return dbEnt.resolvePathComponents(this.dbAttributePath);
    }

    public void setDbAttribute(DbAttribute dbAttribute) {
        if (dbAttribute == null) {
            this.setDbAttributePath(null);
        } else {
            this.setDbAttributePath(dbAttribute.getName());
        }
    }

    public String getDbAttributeName() {
        if (this.dbAttributePath == null) {
            return null;
        }
        int lastDot = this.dbAttributePath.lastIndexOf(46);
        if (lastDot < 0) {
            return this.dbAttributePath;
        }
        return this.dbAttributePath.substring(lastDot + 1);
    }

    public void setDbAttributeName(String name) {
        this.setDbAttributePath(name);
    }

    public void setDbAttributePath(String dbAttributePath) {
        this.dbAttributePath = dbAttributePath;
    }

    public String getDbAttributePath() {
        return this.dbAttributePath;
    }

    public boolean isCompound() {
        return this.isFlattened();
    }

    public boolean isFlattened() {
        return this.dbAttributePath != null && this.dbAttributePath.indexOf(46) >= 0;
    }

    public ObjAttribute getClientAttribute() {
        ClientObjAttribute attribute = new ClientObjAttribute(this.getName());
        attribute.setType(this.getType());
        DbAttribute dbAttribute = this.getDbAttribute();
        if (dbAttribute != null) {
            if (dbAttribute.isPrimaryKey()) {
                attribute.setDbAttributePath(dbAttribute.getName());
                attribute.setPrimaryKey(true);
            }
            attribute.setMandatory(dbAttribute.isMandatory());
            attribute.setMaxLength(dbAttribute.getMaxLength());
        }
        return attribute;
    }
}

