/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class AddRelationshipToModel
extends AbstractToModelToken.Entity {
    private DbRelationship rel;

    public AddRelationshipToModel(DbEntity entity, DbRelationship rel) {
        super(entity);
        this.rel = rel;
    }

    public MergerToken createReverse(MergerFactory factory) {
        return factory.createDropRelationshipToDb(this.getEntity(), this.rel);
    }

    public void execute(MergerContext mergerContext) {
        this.getEntity().addRelationship(this.rel);
        this.synchronizeWithObjEntity(this.getEntity());
    }

    public String getTokenName() {
        return "Add Relationship";
    }

    public String getTokenValue() {
        StringBuilder s = new StringBuilder();
        s.append(this.rel.getSourceEntity().getName());
        s.append("->");
        s.append(this.rel.getTargetEntityName());
        return s.toString();
    }
}

