/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMerger {
    private MergerFactory factory;

    public boolean includeTableName(String tableName) {
        return true;
    }

    public List<MergerToken> createMergeTokens(DataNode dataNode, DataMap dataMap) {
        return this.createMergeTokens(dataNode.getAdapter(), dataNode.getDataSource(), dataMap);
    }

    public List<MergerToken> createMergeTokens(DbAdapter adapter, DataSource dataSource, DataMap dataMap) {
        this.factory = adapter.mergerFactory();
        ArrayList<MergerToken> tokens = new ArrayList<MergerToken>();
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            final DbMerger merger = this;
            DbLoader dbLoader = new DbLoader(conn, adapter, new LoaderDelegate()){

                public boolean includeTableName(String tableName) {
                    return merger.includeTableName(tableName);
                }
            };
            DataMap detectedDataMap = dbLoader.loadDataMapFromDB(null, null, new DataMap());
            HashMap<String, DbEntity> dbEntityToDropByName = new HashMap<String, DbEntity>(detectedDataMap.getDbEntityMap());
            for (DbEntity dbEntity : dataMap.getDbEntities()) {
                String tableName = dbEntity.getName();
                if (!this.includeTableName(tableName)) continue;
                DbEntity detectedEntity = this.findDbEntity(detectedDataMap, tableName);
                if (detectedEntity == null) {
                    tokens.add(this.factory.createCreateTableToDb(dbEntity));
                    for (DbRelationship rel : dbEntity.getRelationships()) {
                        tokens.add(this.factory.createAddRelationshipToDb(dbEntity, rel));
                    }
                    continue;
                }
                dbEntityToDropByName.remove(detectedEntity.getName());
                this.checkRelationshipsToDrop(adapter, tokens, dbEntity, detectedEntity);
                this.checkRows(tokens, dbEntity, detectedEntity);
                this.checkRelationshipsToAdd(adapter, tokens, dbEntity, detectedEntity);
            }
            for (DbEntity e : dbEntityToDropByName.values()) {
                if (!this.includeTableName(e.getName())) continue;
                tokens.add(this.factory.createDropTableToDb(e));
            }
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return tokens;
    }

    private void checkRows(List<MergerToken> tokens, DbEntity dbEntity, DbEntity detectedEntity) {
        for (DbAttribute detected : detectedEntity.getAttributes()) {
            if (this.findDbAttribute(dbEntity, detected.getName()) != null) continue;
            tokens.add(this.factory.createDropColumToDb(dbEntity, detected));
        }
        for (DbAttribute attr : dbEntity.getAttributes()) {
            String columnName = attr.getName().toUpperCase();
            DbAttribute detected = this.findDbAttribute(detectedEntity, columnName);
            if (detected == null) {
                tokens.add(this.factory.createAddColumnToDb(dbEntity, attr));
                if (!attr.isMandatory()) continue;
                tokens.add(this.factory.createSetNotNullToDb(dbEntity, attr));
                continue;
            }
            if (attr.isMandatory() != detected.isMandatory()) {
                if (attr.isMandatory()) {
                    tokens.add(this.factory.createSetNotNullToDb(dbEntity, attr));
                } else {
                    tokens.add(this.factory.createSetAllowNullToDb(dbEntity, attr));
                }
            }
            switch (detected.getType()) {
                case 1: 
                case 12: {
                    if (attr.getMaxLength() == detected.getMaxLength()) break;
                    tokens.add(this.factory.createSetColumnTypeToDb(dbEntity, detected, attr));
                }
            }
        }
    }

    private void checkRelationshipsToDrop(DbAdapter adapter, List<MergerToken> tokens, DbEntity dbEntity, DbEntity detectedEntity) {
        for (DbRelationship detected : detectedEntity.getRelationships()) {
            DbEntity targetEntity;
            if (this.findDbRelationship(dbEntity, detected) != null || (targetEntity = this.findDbEntity(dbEntity.getDataMap(), detected.getTargetEntityName())) == null) continue;
            detected.setSourceEntity(dbEntity);
            detected.setTargetEntity(targetEntity);
            for (DbJoin join : detected.getJoins()) {
                DbAttribute tattr;
                DbAttribute sattr = this.findDbAttribute(dbEntity, join.getSourceName());
                if (sattr != null) {
                    join.setSourceName(sattr.getName());
                }
                if ((tattr = this.findDbAttribute(targetEntity, join.getTargetName())) == null) continue;
                join.setTargetName(tattr.getName());
            }
            MergerToken token = this.factory.createDropRelationshipToDb(dbEntity, detected);
            if (detected.isToMany()) {
                token = token.createReverse(this.factory);
            }
            tokens.add(token);
        }
    }

    private void checkRelationshipsToAdd(DbAdapter adapter, List<MergerToken> tokens, DbEntity dbEntity, DbEntity detectedEntity) {
        for (DbRelationship rel : dbEntity.getRelationships()) {
            AbstractToDbToken t;
            if (!this.includeTableName(rel.getTargetEntityName()) || this.findDbRelationship(detectedEntity, rel) != null || (t = (AbstractToDbToken)this.factory.createAddRelationshipToDb(dbEntity, rel)).createSql(adapter).isEmpty()) continue;
            tokens.add(this.factory.createAddRelationshipToDb(dbEntity, rel));
        }
    }

    private DbEntity findDbEntity(DataMap map, String caseInsensitiveName) {
        for (DbEntity e : map.getDbEntities()) {
            if (!e.getName().equalsIgnoreCase(caseInsensitiveName)) continue;
            return e;
        }
        return null;
    }

    private DbAttribute findDbAttribute(DbEntity entity, String caseInsensitiveName) {
        for (DbAttribute a : entity.getAttributes()) {
            if (!a.getName().equalsIgnoreCase(caseInsensitiveName)) continue;
            return a;
        }
        return null;
    }

    private DbRelationship findDbRelationship(DbEntity entity, DbRelationship rel) {
        for (DbRelationship candidate : entity.getRelationships()) {
            if (!DbMerger.equalDbJoinCollections(candidate.getJoins(), rel.getJoins())) continue;
            return candidate;
        }
        return null;
    }

    private static boolean equalDbJoinCollections(Collection<DbJoin> j1s, Collection<DbJoin> j2s) {
        if (j1s.size() != j2s.size()) {
            return false;
        }
        for (DbJoin j1 : j1s) {
            boolean foundPair = false;
            for (DbJoin j2 : j2s) {
                if (j1.getSource() == null || j1.getSource().getEntity() == null || j1.getTarget() == null || j1.getTarget().getEntity() == null || j2.getSource() == null || j2.getSource().getEntity() == null || j2.getTarget() == null || j2.getTarget().getEntity() == null || !j1.getSource().getEntity().getName().equalsIgnoreCase(j2.getSource().getEntity().getName()) || !j1.getTarget().getEntity().getName().equalsIgnoreCase(j2.getTarget().getEntity().getName()) || !j1.getSourceName().equalsIgnoreCase(j2.getSourceName()) || !j1.getTargetName().equalsIgnoreCase(j2.getTargetName())) continue;
                foundPair = true;
                break;
            }
            if (foundPair) continue;
            return false;
        }
        return true;
    }

    private static final class LoaderDelegate
    implements DbLoaderDelegate {
        private LoaderDelegate() {
        }

        public void dbEntityAdded(DbEntity ent) {
        }

        public void dbEntityRemoved(DbEntity ent) {
        }

        public void objEntityAdded(ObjEntity ent) {
        }

        public void objEntityRemoved(ObjEntity ent) {
        }

        public boolean overwriteDbEntity(DbEntity ent) throws CayenneException {
            return false;
        }
    }
}

