/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.access.trans.JoinTreeNode;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;

public class JoinStack {
    protected JoinTreeNode rootNode = new JoinTreeNode(this);
    protected JoinTreeNode topNode;
    private int aliasCounter;

    protected JoinStack() {
        this.rootNode.setTargetTableAlias(this.newAlias());
        this.resetStack();
    }

    String getCurrentAlias() {
        return this.topNode.getTargetTableAlias();
    }

    protected int size() {
        return this.rootNode.size() - 1;
    }

    void appendRoot(Appendable out, DbEntity rootEntity) throws IOException {
        out.append(rootEntity.getFullyQualifiedName());
        out.append(' ').append(this.rootNode.getTargetTableAlias());
    }

    protected void appendJoins(Appendable out) throws IOException {
        for (JoinTreeNode child : this.rootNode.getChildren()) {
            this.appendJoinSubtree(out, child);
        }
    }

    protected void appendJoinSubtree(Appendable out, JoinTreeNode node) throws IOException {
        DbRelationship relationship = node.getRelationship();
        DbEntity targetEntity = (DbEntity)relationship.getTargetEntity();
        String srcAlias = node.getSourceTableAlias();
        String targetAlias = node.getTargetTableAlias();
        switch (node.getJoinType()) {
            case INNER: {
                out.append(" JOIN");
                break;
            }
            case LEFT_OUTER: {
                out.append(" LEFT JOIN");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported join type: " + (Object)((Object)node.getJoinType()));
            }
        }
        out.append(' ').append(targetEntity.getFullyQualifiedName()).append(' ').append(targetAlias).append(" ON (");
        List<DbJoin> joins = relationship.getJoins();
        int len = joins.size();
        for (int i = 0; i < len; ++i) {
            DbJoin join = joins.get(i);
            if (i > 0) {
                out.append(" AND ");
            }
            out.append(srcAlias).append('.').append(join.getSourceName()).append(" = ").append(targetAlias).append('.').append(join.getTargetName());
        }
        out.append(')');
        for (JoinTreeNode child : node.getChildren()) {
            this.appendJoinSubtree(out, child);
        }
    }

    protected void appendQualifier(Appendable out, boolean firstQualifyerElement) throws IOException {
    }

    void resetStack() {
        this.topNode = this.rootNode;
    }

    void pushJoin(DbRelationship relationship, JoinType joinType, String alias) {
        this.topNode = this.topNode.findOrCreateChild(relationship, joinType, alias);
    }

    protected String newAlias() {
        return "t" + this.aliasCounter++;
    }
}

