/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.DbAdapterFactory;
import org.apache.cayenne.dba.DbAdapterFactoryChain;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.db2.DB2Sniffer;
import org.apache.cayenne.dba.derby.DerbySniffer;
import org.apache.cayenne.dba.frontbase.FrontBaseSniffer;
import org.apache.cayenne.dba.h2.H2Sniffer;
import org.apache.cayenne.dba.hsqldb.HSQLDBSniffer;
import org.apache.cayenne.dba.ingres.IngresSniffer;
import org.apache.cayenne.dba.mysql.MySQLSniffer;
import org.apache.cayenne.dba.openbase.OpenBaseSniffer;
import org.apache.cayenne.dba.oracle.OracleSniffer;
import org.apache.cayenne.dba.postgres.PostgresSniffer;
import org.apache.cayenne.dba.sqlite.SQLiteSniffer;
import org.apache.cayenne.dba.sqlserver.SQLServerSniffer;
import org.apache.cayenne.dba.sybase.SybaseSniffer;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoAdapter
implements DbAdapter {
    static final List<DbAdapterFactory> defaultFactories = new ArrayList<DbAdapterFactory>();
    protected DbAdapterFactory adapterFactory;
    protected DataSource dataSource;
    protected PkGenerator pkGenerator;
    DbAdapter adapter;

    public static void addFactory(DbAdapterFactory factory) {
        defaultFactories.add(factory);
    }

    public static DbAdapterFactory getDefaultFactory() {
        return new DbAdapterFactoryChain(defaultFactories);
    }

    public AutoAdapter(DataSource dataSource) {
        this(null, dataSource);
    }

    public AutoAdapter(DbAdapterFactory adapterFactory, DataSource dataSource) {
        if (dataSource == null) {
            throw new CayenneRuntimeException("Null dataSource");
        }
        this.adapterFactory = adapterFactory != null ? adapterFactory : this.createDefaultFactory();
        this.dataSource = dataSource;
    }

    protected DbAdapterFactory createDefaultFactory() {
        return AutoAdapter.getDefaultFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DbAdapter getAdapter() {
        if (this.adapter == null) {
            AutoAdapter autoAdapter = this;
            synchronized (autoAdapter) {
                if (this.adapter == null) {
                    this.adapter = this.loadAdapter();
                }
            }
        }
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DbAdapter loadAdapter() {
        DbAdapter adapter = null;
        try {
            Connection c = this.dataSource.getConnection();
            try {
                adapter = this.adapterFactory.createAdapter(c.getMetaData());
            }
            finally {
                try {
                    c.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("Error detecting database type: " + e.getLocalizedMessage(), e);
        }
        if (adapter == null) {
            QueryLogger.log("Failed to detect database type, using default adapter");
            adapter = new JdbcAdapter();
        } else {
            QueryLogger.log("Detected and installed adapter: " + adapter.getClass().getName());
        }
        return adapter;
    }

    @Override
    public String getBatchTerminator() {
        return this.getAdapter().getBatchTerminator();
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return this.getAdapter().getQualifierTranslator(queryAssembler);
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return this.getAdapter().getAction(query, node);
    }

    @Override
    public boolean supportsFkConstraints() {
        return this.getAdapter().supportsFkConstraints();
    }

    @Override
    public boolean supportsUniqueConstraints() {
        return this.getAdapter().supportsUniqueConstraints();
    }

    @Override
    public boolean supportsGeneratedKeys() {
        return this.getAdapter().supportsGeneratedKeys();
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.getAdapter().supportsBatchUpdates();
    }

    @Override
    public String dropTable(DbEntity entity) {
        return this.getAdapter().dropTable(entity);
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        return this.getAdapter().dropTableStatements(table);
    }

    @Override
    public String createTable(DbEntity entity) {
        return this.getAdapter().createTable(entity);
    }

    @Override
    public String createUniqueConstraint(DbEntity source, Collection<DbAttribute> columns) {
        return this.getAdapter().createUniqueConstraint(source, columns);
    }

    @Override
    public String createFkConstraint(DbRelationship rel) {
        return this.getAdapter().createFkConstraint(rel);
    }

    @Override
    public String[] externalTypesForJdbcType(int type) {
        return this.getAdapter().externalTypesForJdbcType(type);
    }

    @Override
    public ExtendedTypeMap getExtendedTypes() {
        return this.getAdapter().getExtendedTypes();
    }

    @Override
    public PkGenerator getPkGenerator() {
        return this.pkGenerator != null ? this.pkGenerator : this.getAdapter().getPkGenerator();
    }

    public void setPkGenerator(PkGenerator pkGenerator) {
        this.pkGenerator = pkGenerator;
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        return this.getAdapter().buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    @Override
    public void bindParameter(PreparedStatement statement, Object object, int pos, int sqlType, int precision) throws SQLException, Exception {
        this.getAdapter().bindParameter(statement, object, pos, sqlType, precision);
    }

    @Override
    public String tableTypeForTable() {
        return this.getAdapter().tableTypeForTable();
    }

    @Override
    public String tableTypeForView() {
        return this.getAdapter().tableTypeForView();
    }

    @Override
    public MergerFactory mergerFactory() {
        return this.getAdapter().mergerFactory();
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        this.getAdapter().createTableAppendColumn(sqlBuffer, column);
    }

    static {
        defaultFactories.addAll(Arrays.asList(new MySQLSniffer(), new PostgresSniffer(), new OracleSniffer(), new SQLServerSniffer(), new HSQLDBSniffer(), new DB2Sniffer(), new SybaseSniffer(), new DerbySniffer(), new OpenBaseSniffer(), new FrontBaseSniffer(), new IngresSniffer(), new SQLiteSniffer(), new H2Sniffer()));
    }
}

