/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.openbase;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.access.trans.JoinStack;
import org.apache.cayenne.access.trans.JoinTreeNode;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;

public class OpenBaseJoinStack
extends JoinStack {
    protected void appendJoinSubtree(Appendable out, JoinTreeNode node) throws IOException {
        DbRelationship relationship = node.getRelationship();
        if (relationship == null) {
            return;
        }
        DbEntity targetEntity = (DbEntity)relationship.getTargetEntity();
        String targetAlias = node.getTargetTableAlias();
        out.append(", ").append(targetEntity.getFullyQualifiedName()).append(' ').append(targetAlias);
        for (JoinTreeNode child : node.getChildren()) {
            this.appendJoinSubtree(out, child);
        }
    }

    protected void appendQualifier(Appendable out, boolean firstQualifyerElement) throws IOException {
        boolean first = firstQualifyerElement;
        for (JoinTreeNode node : this.rootNode.getChildren()) {
            if (!first) {
                out.append(" AND ");
            }
            this.appendQualifierSubtree(out, node);
            first = false;
        }
    }

    protected void appendQualifierSubtree(Appendable out, JoinTreeNode node) throws IOException {
        DbRelationship relationship = node.getRelationship();
        String srcAlias = node.getSourceTableAlias();
        String targetAlias = node.getTargetTableAlias();
        List<DbJoin> joins = relationship.getJoins();
        int len = joins.size();
        for (int i = 0; i < len; ++i) {
            DbJoin join = joins.get(i);
            if (i > 0) {
                out.append(" AND ");
            }
            out.append(srcAlias).append('.').append(join.getSourceName());
            switch (node.getJoinType()) {
                case INNER: {
                    out.append(" = ");
                    break;
                }
                case LEFT_OUTER: {
                    out.append(" * ");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported join type: " + (Object)((Object)node.getJoinType()));
                }
            }
            out.append(targetAlias).append('.').append(join.getTargetName());
        }
        for (JoinTreeNode child : node.getChildren()) {
            out.append(" AND ");
            this.appendQualifierSubtree(out, child);
        }
    }
}

