/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.Transaction;

public class JpaTransaction
implements EntityTransaction {
    protected EntityManager entityManager;
    protected Transaction transaction;
    protected boolean rollbackOnly;

    public JpaTransaction(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.reset();
    }

    protected void reset() {
        this.transaction = Transaction.internalTransaction(null);
    }

    public void begin() {
        if (this.isActive()) {
            throw new IllegalStateException("transaction active");
        }
        this.transaction.begin();
    }

    public void commit() {
        if (!this.isActive()) {
            throw new IllegalStateException("transaction not active");
        }
        try {
            this.entityManager.flush();
            this.transaction.commit();
        }
        catch (SQLException e) {
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        catch (CayenneException e) {
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        this.reset();
    }

    public void rollback() {
        if (!this.isActive()) {
            throw new IllegalStateException("transaction not active");
        }
        try {
            this.transaction.rollback();
        }
        catch (SQLException e) {
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        catch (CayenneException e) {
            throw new PersistenceException(e.getMessage(), (Throwable)e);
        }
        this.reset();
    }

    public boolean isActive() {
        return this.transaction.getStatus() == 1;
    }

    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }
}

