/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.JpaUnitClassLoader;
import org.apache.cayenne.jpa.conf.JpaDataSourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaUnit
implements PersistenceUnitInfo {
    protected String persistenceUnitName;
    protected List<String> mappingFileNames = new ArrayList<String>(2);
    protected List<URL> jarFileUrls = new ArrayList<URL>(2);
    protected List<String> managedClassNames = new ArrayList<String>(30);
    protected URL persistenceUnitRootUrl;
    protected boolean excludeUnlistedClasses;
    protected Properties properties = new Properties();
    protected String description;
    protected ClassLoader classLoader;

    public JpaUnit() {
        this.setDefaultClassLoader();
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public String getPersistenceProviderClassName() {
        return this.getProperty("javax.persistence.provider");
    }

    public abstract void addTransformer(ClassTransformer var1);

    public PersistenceUnitTransactionType getTransactionType() {
        String type = this.getProperty("javax.persistence.transactionType");
        return type != null ? PersistenceUnitTransactionType.valueOf((String)type) : PersistenceUnitTransactionType.JTA;
    }

    String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    JpaDataSourceFactory getJpaDataSourceFactory() {
        String factory = this.getProperty("org.apache.cayenne.jpa.jpaDataSourceFactory");
        if (factory == null) {
            throw new JpaProviderException("No value for 'org.apache.cayenne.jpa.jpaDataSourceFactory' property - can't build DataSource factory.");
        }
        try {
            return (JpaDataSourceFactory)Class.forName(factory, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Throwable th) {
            throw new JpaProviderException("Error instantiating a JPADataSourceFactory: " + factory, th);
        }
    }

    public DataSource getJtaDataSource() {
        String name = this.getProperty("javax.persistence.jtaDataSource");
        return this.getJpaDataSourceFactory().getJtaDataSource(name, this);
    }

    public DataSource getNonJtaDataSource() {
        String name = this.getProperty("javax.persistence.nonJtaDataSource");
        return this.getJpaDataSourceFactory().getNonJtaDataSource(name, this);
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public List<URL> getJarFileUrls() {
        return this.jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getNewTempClassLoader() {
        return new JpaUnitClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public void addJarFileUrl(String jarName) {
        if (this.persistenceUnitRootUrl == null) {
            throw new IllegalStateException("Persistence Unit Root URL is not set");
        }
        try {
            this.jarFileUrls.add(new URL(this.persistenceUnitRootUrl, jarName));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid Jar file name:" + jarName, e);
        }
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            this.setDefaultClassLoader();
        } else {
            this.classLoader = classLoader;
        }
    }

    protected void setDefaultClassLoader() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public void addManagedClassName(String managedClassName) {
        this.managedClassNames.add(managedClassName);
    }

    public void addMappingFileName(String mappingFileName) {
        this.mappingFileNames.add(mappingFileName);
    }

    public void setPersistenceUnitRootUrl(URL persistenceUnitRootUrl) {
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    public void addProperties(Map<?, ?> properties) {
        this.properties.putAll(properties);
    }

    public void putProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

